<?php
    header("Access-Control-Allow-Origin: *");
    header("Content-Type: application/json; charset=UTF-8");
    header("Access-Control-Allow-Methods: POST");
    header("Access-Control-Max-Age: 3600");
    header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

	include_once '../class/auth.php';
    include_once '../config/database.php';
    include_once '../class/corretores.php';
	
	
    $database = new Database();
    $db = $database->getConnection();


    //autenticação
    $token = null;
    $headers = apache_request_headers();
    if(isset($headers['Authorization'])){
        $matches = array();
        $token = $headers['Authorization'];
  
        $item = new userGerencieImobiliario($db);
        $item->token = $token;
        $item->getUserToken();
        if($item->users_id != null){
            //$emp_arr = array("usuarioID" =>  $item->users_id);
            http_response_code(200);
            //setcookie('gerenciadorImobiliarioUsuarioID', $item->users_id, time() + (60 * 2), "/");
            $gerenciadorImobiliarioUsuarioID = $item->users_id;
            //echo json_encode($emp_arr);
        }
        else
        {
            http_response_code(404);
            echo json_encode(
                array("status" => "error", "message" => "404 - N&atilde;o autorizado.")
            );
            die();
        }
    }
    else
    {
        http_response_code(401);
        echo json_encode(
            array("status" => "error", "message" => "401 - N&atilde;o autorizado.")
        );
        die();
    }
    

    if(!isset($_GET['corretorID'])){
        http_response_code(404);
        echo json_encode(
            array("status" => "error", "message" => "404 - Registro inexistente.")
        );
        die();
    }
        if ( filter_var($_GET['corretorID'], FILTER_VALIDATE_INT) === false ) {
            http_response_code(404);
            echo json_encode(
                array("status" => "error", "message" => "404 - Registro inexistente.")
            );
            die();
        }


    $item = new Corretores($db);
    $item->id = isset($_GET['corretorID']) ? (int)$_GET['corretorID'] : die();
    
    $item->getCorretorID(); 

    if($item->id != null){
        // create array
        $emp_arr = array(
            'id' => $item->id,
            'userID' => $item->userID,
            'nome' => $item->nome,
            'email' => $item->email,
            'perfil' => $item->perfil,
            'celular' => $item->telefone,
            'cadastro' => $item->cadastro
        );
 
        echo json_encode($emp_arr);
    }
    else{
        http_response_code(404);
        echo json_encode(
            array("status" => "error", "message" => "404 - Registro inexistente.")
        );
        die();
    }
 