<?php
    header("Access-Control-Allow-Origin: *");
    header("Content-Type: application/json; charset=UTF-8");
    header("Access-Control-Allow-Methods: POST");
    header("Access-Control-Max-Age: 3600");
    header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

	include_once '../class/auth.php';
    include_once '../config/database.php';
    include_once '../class/imoveis.php';
	
	
    $database = new Database();
    $db = $database->getConnection();



	//autenticação
	$token = null;
	$headers = apache_request_headers();
	if(isset($headers['Authorization'])){
		$matches = array();
		$token = $headers['Authorization'];
  
		$item = new userGerencieImobiliario($db);
		$item->token = $token;
		$item->getUserToken();
		if($item->users_id != null){
			//$emp_arr = array("usuarioID" =>  $item->users_id);
			http_response_code(200);
			//setcookie('gerenciadorImobiliarioUsuarioID', $item->users_id, time() + (60 * 2), "/");
			$gerenciadorImobiliarioUsuarioID = $item->users_id;
			//echo json_encode($emp_arr);
		}
		else
		{
			http_response_code(404);
			echo json_encode(
				array("status" => "error", "message" => "404 - N&atilde;o autorizado.")
			);
			die();
		}
	}
	else
	{
		http_response_code(401);
        echo json_encode(
            array("status" => "error", "message" => "401 - N&atilde;o autorizado.")
        );
		die();
	}
	

	if(!isset($_GET['imovelID'])){
		http_response_code(404);
        echo json_encode(
            array("status" => "error", "message" => "404 - Registro inexistente.")
        );
		die();
	}
		if ( filter_var($_GET['imovelID'], FILTER_VALIDATE_INT) === false ) {
			http_response_code(404);
			echo json_encode(
				array("status" => "error", "message" => "404 - Registro inexistente.")
			);
			die();
		}


    $item = new Imoveis($db);
    $item->id = isset($_GET['imovelID']) ? (int)$_GET['imovelID'] : die();
	
    $item->getImovelID();
    if($item->titulo != null){
        // create array
        $emp_arr = array(
			'id' => $item->id,
			'userID' => $item->userID,
			'angariador_corretor' => $item->angariador_corretor,
			'proprietario' => $item->proprietario,
			'titulo' => $item->titulo,
			'situacao' => $item->situacao,
			'categoria' => $item->categoria,
			'valor' => $item->valor,
			'indice_de_reajuste_ao_consumidor' => $item->indice_de_reajuste_ao_consumidor,
			'area_total' => $item->area_total,
			'indice_cadastral' => $item->indice_cadastral,
			'construtora' => $item->construtora,
			'idade' => $item->idade,
			'posicao' => $item->posicao,
			'topografia' => $item->topografia,
			'taxa_do_condominio' => $item->taxa_do_condominio,
			'iptu' => $item->iptu,
			'permuta' => $item->permuta,
			'imovel_ocupado' => $item->imovel_ocupado,
			'rua' => $item->rua,
			'numero' => $item->numero,
			'bairro' => $item->bairro,
			'estado' => $item->estado,
			'cidade' => $item->cidade,
			'descricao_do_imovel' => $item->descricao_do_imovel,
			'observacoes_internas' => $item->observacoes_internas,
			'condicao_de_pagamento' => $item->condicao_de_pagamento,
			'quitado' => $item->quitado,
			'comissao_da_imobiliaria' => $item->comissao_da_imobiliaria,
			'informacoes_documentacao' => $item->informacoes_documentacao,
			'dormitorio' => $item->dormitorio,
			'suite' => $item->suite,
			'suite_c_closet' => $item->suite_c_closet,
			'demi_suite' => $item->demi_suite,
			'sala' => $item->sala,
			'sala_de_estar' => $item->sala_de_estar,
			'sala_de_tv' => $item->sala_de_tv,
			'garagem' => $item->garagem,
			'garagem_descoberta' => $item->garagem_descoberta,
			'banheiro' => $item->banheiro,
			'andar' => $item->andar,
			'elevador' => $item->elevador,
			'edicula' => $item->edicula,
			'horta' => $item->horta,
			'jardim' => $item->jardim,
			'area_de_servico' => $item->area_de_servico,
			'bar' => $item->bar,
			'biblioteca' => $item->biblioteca,
			'closet' => $item->closet,
			'copa' => $item->copa,
			'despensa' => $item->despensa,
			'escritorio' => $item->escritorio,
			'lareira' => $item->lareira,
			'sala_de_ginastica' => $item->sala_de_ginastica,
			'sala_de_jantar' => $item->sala_de_jantar,
			'acesso_a_deficiente' => $item->acesso_a_deficiente,
			'gerador_de_energia' => $item->gerador_de_energia,
			'guarita' => $item->guarita,
			'lavanderia_coletiva' => $item->lavanderia_coletiva,
			'medicao' => $item->medicao,
			'agua_individual' => $item->agua_individual,
			'portaria_24_horas' => $item->portaria_24_horas,
			'bicicletario' => $item->bicicletario,
			'churrasqueira' => $item->churrasqueira,
			'ducha_externa' => $item->ducha_externa,
			'piscina' => $item->piscina,
			'playground' => $item->playground,
			'quadra_de_esportes' => $item->quadra_de_esportes,
			'quadra_tenis' => $item->quadra_tenis,
			'sala_ginastica_fitness' => $item->sala_ginastica_fitness,
			'salao_de_festas' => $item->salao_de_festas,
			'salao_de_jogos' => $item->salao_de_jogos,
			'sauna' => $item->sauna,
			'alarme' => $item->alarme,
			'camera_de_vigilancia' => $item->camera_de_vigilancia,
			'fechadura_reforcada' => $item->fechadura_reforcada,
			'interfone' => $item->interfone,
			'muro_com_cerca_eletrica' => $item->muro_com_cerca_eletrica,
			'portao_eletronico' => $item->portao_eletronico,
			'vigilancia_24_horas' => $item->vigilancia_24_horas,
			'id_imobiliaria' => $item->id_imobiliaria,
			'data_criacao' => $item->data_criacao
        );
      
        http_response_code(200);
        echo json_encode($emp_arr);
    }
    else{
        http_response_code(404);
		echo json_encode(
			array("status" => "error", "message" => "404 - Registro inexistente.")
		);
		die();
    }
?>