<?php
    header("Access-Control-Allow-Origin: *");
    header("Content-Type: application/json; charset=UTF-8");
    
	include_once '../class/auth.php';
    include_once '../config/database.php';
    include_once '../class/imoveis.php';
	
	
	
    $database = new Database();
    $db = $database->getConnection();
 
 
	//autenticação
	$token = null;
	$headers = apache_request_headers();
	if(isset($headers['Authorization'])){
		$matches = array();
		$token = $headers['Authorization'];
  
		$item = new userGerencieImobiliario($db);
		$item->token = $token;
		$item->getUserToken();
		if($item->users_id != null){
			//$emp_arr = array("usuarioID" =>  $item->users_id);
			http_response_code(200);
			//setcookie('gerenciadorImobiliarioUsuarioID', $item->users_id, time() + (60 * 2), "/");
			$gerenciadorImobiliarioUsuarioID = $item->users_id;
			//echo json_encode($emp_arr);
		}
		else
		{
			http_response_code(404);
			echo json_encode(
				array("status" => "error", "message" => "404 - N&atilde;o autorizado.")
			);
			die();
		}
	}
	else
	{
		http_response_code(401);
        echo json_encode(
            array("status" => "error", "message" => "401 - N&atilde;o autorizado.")
        );
		die();
	}
	


    $items = new Imoveis($db);
	$items->gerenciadorImobiliarioUsuarioID = $gerenciadorImobiliarioUsuarioID;
    $stmt = $items->getImovel();
	//ECHO $stmt;
    $itemCount = $stmt->rowCount();


    //echo json_encode($itemCount);

    if($itemCount > 0){
        
        $employeeArr = array();
        $employeeArr["itens"] = array();
        $employeeArr["totalItens"] = $itemCount;

        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)){
            extract($row);
            $e = array(
				'id' => $id,
				'angariador_corretor' => $angariador_corretor,
				'proprietario' => $proprietario,
				'titulo' => $titulo,
				'situacao' => $situacao,
				'categoria' => $categoria,
				'valor' => $valor,
				'indice_de_reajuste_ao_consumidor' => $indice_de_reajuste_ao_consumidor,
				'area_total' => $area_total,
				'indice_cadastral' => $indice_cadastral,
				'construtora' => $construtora,
				'idade' => $idade,
				'posicao' => $posicao,
				'topografia' => $topografia,
				'taxa_do_condominio' => $taxa_do_condominio,
				'iptu' => $iptu,
				'permuta' => $permuta,
				'imovel_ocupado' => $imovel_ocupado,
				'rua' => $rua,
				'numero' => $numero,
				'bairro' => $bairro,
				'estado' => $estado,
				'cidade' => $cidade,
				'descricao_do_imovel' => $descricao_do_imovel,
				'observacoes_internas' => $observacoes_internas,
				'condicao_de_pagamento' => $condicao_de_pagamento,
				'quitado' => $quitado,
				'comissao_da_imobiliaria' => $comissao_da_imobiliaria,
				'informacoes_documentacao' => $informacoes_documentacao,
				'dormitorio' => $dormitorio,
				'suite' => $suite,
				'suite_c_closet' => $suite_c_closet,
				'demi_suite' => $demi_suite,
				'sala' => $sala,
				'sala_de_estar' => $sala_de_estar,
				'sala_de_tv' => $sala_de_tv,
				'garagem' => $garagem,
				'garagem_descoberta' => $garagem_descoberta,
				'banheiro' => $banheiro,
				'andar' => $andar,
				'elevador' => $elevador,
				'edicula' => $edicula,
				'horta' => $horta,
				'jardim' => $jardim,
				'area_de_servico' => $area_de_servico,
				'bar' => $bar,
				'biblioteca' => $biblioteca,
				'closet' => $closet,
				'copa' => $copa,
				'despensa' => $despensa,
				'escritorio' => $escritorio,
				'lareira' => $lareira,
				'sala_de_ginastica' => $sala_de_ginastica,
				'sala_de_jantar' => $sala_de_jantar,
				'acesso_a_deficiente' => $acesso_a_deficiente,
				'gerador_de_energia' => $gerador_de_energia,
				'guarita' => $guarita,
				'lavanderia_coletiva' => $lavanderia_coletiva,
				'medicao' => $medicao,
				'agua_individual' => $agua_individual,
				'portaria_24_horas' => $portaria_24_horas,
				'bicicletario' => $bicicletario,
				'churrasqueira' => $churrasqueira,
				'ducha_externa' => $ducha_externa,
				'piscina' => $piscina,
				'playground' => $playground,
				'quadra_de_esportes' => $quadra_de_esportes,
				'quadra_tenis' => $quadra_tenis,
				'sala_ginastica_fitness' => $sala_ginastica_fitness,
				'salao_de_festas' => $salao_de_festas,
				'salao_de_jogos' => $salao_de_jogos,
				'sauna' => $sauna,
				'alarme' => $alarme,
				'camera_de_vigilancia' => $camera_de_vigilancia,
				'fechadura_reforcada' => $fechadura_reforcada,
				'interfone' => $interfone,
				'muro_com_cerca_eletrica' => $muro_com_cerca_eletrica,
				'portao_eletronico' => $portao_eletronico,
				'vigilancia_24_horas' => $vigilancia_24_horas,
				'id_imobiliaria' => $id_imobiliaria,
				'data_criacao' => $data_criacao
            );

            array_push($employeeArr["itens"], $e);
        }
        echo json_encode($employeeArr);
    }

    else{
        http_response_code(404);
        echo json_encode(
            array("status" => "error", "message" => "Nenhum resultado encontrado.")
        );
    }
?>