<?php
    class Corretores{

        // Connection
        private $conn;

        // Table
        private $db_table = "users";

        // Columns
		public $id;
		public $nome;
		public $sobrenome;
		public $telefone;
		public $email;
		public $perfil;
		public $id_imobiliaria;
		public $data_criacao;

		public $gerenciadorImobiliarioUsuarioID;

        // Db connection
        public function __construct($db){
            $this->conn = $db;
        }

        // GET ALL
        public function getCorretor(){
			$usuarioID = (int)$this->gerenciadorImobiliarioUsuarioID;
			
            $sqlQuery = "
				SELECT
					users.id,
					users.nome,
					users.sobrenome,
					users.email,
					users.telefone,
					users.perfil,
					users.id_imobiliaria
				FROM
					users,
					imobiliarias
				WHERE
					users.id_imobiliaria = imobiliarias.id_user AND
					imobiliarias.id_user = $usuarioID
			";
            $stmt = $this->conn->prepare($sqlQuery);
            $stmt->execute();
            return $stmt;
        }

  
        // CAPTURA CORRETOR PELO ID
        public function getCorretorID(){
			
			$itemID = (int)$this->id;
            $sqlQuery = "SELECT
                        *
                      FROM
                        ". $this->db_table ."
                    WHERE 
                       id = ?
                    LIMIT 0,1";

            $stmt = $this->conn->prepare($sqlQuery);
            $stmt->bindParam(1, $this->id);
            $stmt->execute();
            $dataRow = $stmt->fetch(PDO::FETCH_ASSOC);
			

			//captura ID do usuario
            $sqlQueryiduSUARIO = "
				SELECT
					imobiliarias.id_user as userID
				FROM
					imobiliarias
				WHERE
					imobiliarias.id = '{$dataRow['id_imobiliaria']}'
			";
            $dadosUsuarioQ = $this->conn->prepare($sqlQueryiduSUARIO);
            $dadosUsuarioQ->execute();
 			$dadosUsuario = $dadosUsuarioQ->fetch(PDO::FETCH_ASSOC);

			//captura ID do usuario
			$this->id = $dataRow['id'];
			$this->userID = $dadosUsuario['userID'];
			$this->nome = $dataRow['nome'].' '.$dataRow['sobrenome'];
			$this->email = $dataRow['email'];
			$this->perfil = $dataRow['perfil'];
			$this->telefone = $dataRow['telefone'];
			$this->cadastro = $dataRow['data_criacao'];

         }        


 
		//CADASTRA CORRETOR
        public function cadastraCorretor(){
            $sqlQuery = "
				INSERT INTO
                       ". $this->db_table ."
				SET
					nome = :nome, 
					sobrenome = :sobrenome, 
					telefone = :telefone, 
					email = :email,
					id_imobiliaria = :id_imobiliaria, 
					data_criacao = :data_criacao
			";
			
				try {
			            $stmt = $this->conn->prepare($sqlQuery);  

						$dataCadastro = date("Y-m-d H:i:s");
						$codigo   = uniqid(time().'.'.rand(), true);
						//$stmt->bindParam(':usuario_id' , $_SESSION['userID'], PDO::PARAM_STR);
						//$stmt->bindParam(':codigo' , $codigo, PDO::PARAM_STR);
						$stmt->bindParam(':nome' , $this->nome, PDO::PARAM_STR);
						$stmt->bindParam(':sobrenome' , $this->sobrenome, PDO::PARAM_STR);
						$stmt->bindParam(':telefone' , $this->telefone, PDO::PARAM_STR);
						$stmt->bindParam(':email' , $this->email, PDO::PARAM_STR);
						$stmt->bindParam(':id_imobiliaria' , $this->imobiliariaID, PDO::PARAM_STR);
						$stmt->bindParam(':data_criacao' , $dataCadastro, PDO::PARAM_STR);
			            if($stmt->execute()){
							$id_corretor = $this->conn->lastInsertId();
							return $id_corretor;
			            }
						else
						{
							return false;
						}
				}
				catch(PDOException $e) {
					echo $e;
				}
        }





 
		//ATUALIZA Corretor
        public function atualizaCorretor(){

			$gerencieCorretorID = (int)$this->gerencieCorretorID;
            $sqlQueryC = "
            	SELECT
                       *
                  FROM
                    ". $this->db_table ."
                WHERE 
                   id = ?
                LIMIT 0,1
            ";

            $stmt = $this->conn->prepare($sqlQueryC);
            $stmt->bindParam(1, $gerencieCorretorID);
            $stmt->execute();
            $dadosCorretorGerenciador = $stmt->fetch(PDO::FETCH_ASSOC);
			 

            $sqlQuery = "
					UPDATE
						". $this->db_table ."
					set
						nome = :nome, 
						sobrenome = :sobrenome, 
						telefone = :telefone, 
						email = :email
					where
						id = :gerenciadorCorretorID and
						id_imobiliaria = :gerenciadorImobiliariaID
			";
			
				try {
			            $stmt = $this->conn->prepare($sqlQuery); 
 
						$dataCadastro = date("Y-m-d H:i:s");
						$codigo   = uniqid(time().'.'.rand(), true); 
						$stmt->bindParam(':nome' , $this->nome, PDO::PARAM_STR);
						$stmt->bindParam(':sobrenome' , $this->sobrenome, PDO::PARAM_STR);
						$stmt->bindParam(':telefone' , $this->telefone, PDO::PARAM_STR);
						$stmt->bindParam(':email' , $this->email, PDO::PARAM_STR);
						
						$stmt->bindParam(':gerenciadorImobiliariaID' , $dadosCorretorGerenciador['id_imobiliaria'], PDO::PARAM_STR);
						$stmt->bindParam(':gerenciadorCorretorID' , $dadosCorretorGerenciador['id'], PDO::PARAM_STR);			
 			            if($stmt->execute()){
			            	 
							return 'sucesso';
			            }
						else
						{
							print_r($stmt->errorInfo());	
							return false;
						}
				}
				catch(PDOException $e) {
					echo $e;
				}
        }






        // UPDATE
        public function updateEmployee(){
            $sqlQuery = "UPDATE
                        ". $this->db_table ."
                    SET
                        name = :name, 
                        email = :email, 
                        age = :age, 
                        designation = :designation, 
                        created = :created
                    WHERE 
                        id = :id";
        
            $stmt = $this->conn->prepare($sqlQuery);
        
            $this->name=htmlspecialchars(strip_tags($this->name));
            $this->email=htmlspecialchars(strip_tags($this->email));
            $this->age=htmlspecialchars(strip_tags($this->age));
            $this->designation=htmlspecialchars(strip_tags($this->designation));
            $this->created=htmlspecialchars(strip_tags($this->created));
            $this->id=htmlspecialchars(strip_tags($this->id));
        
            // bind data
            $stmt->bindParam(":name", $this->name);
            $stmt->bindParam(":email", $this->email);
            $stmt->bindParam(":age", $this->age);
            $stmt->bindParam(":designation", $this->designation);
            $stmt->bindParam(":created", $this->created);
            $stmt->bindParam(":id", $this->id);
        
            if($stmt->execute()){
               return true;
            }
            return false;
        }








        // DELETE
        function deleteEmployee(){
            $sqlQuery = "DELETE FROM " . $this->db_table . " WHERE id = ?";
            $stmt = $this->conn->prepare($sqlQuery);
        
            $this->id=htmlspecialchars(strip_tags($this->id));
        
            $stmt->bindParam(1, $this->id);
        
            if($stmt->execute()){
                return true;
            }
            return false;
        }

    }
?>

