<?php
    class Imoveis{

        // Connection
        private $conn;

        // Table
        private $db_table = "imoveis";

        // Columns
		public $id;
		public $userID;
		public $angariador_corretor;
		public $proprietario;
		public $titulo;
		public $situacao;
		public $categoria;
		public $valor;
		public $indice_de_reajuste_ao_consumidor;
		public $area_total;
		public $indice_cadastral;
		public $construtora;
		public $idade;
		public $posicao;
		public $topografia;
		public $taxa_do_condominio;
		public $iptu;
		public $permuta;
		public $imovel_ocupado;
		public $rua;
		public $numero;
		public $bairro;
		public $estado;
		public $cidade;
		public $descricao_do_imovel;
		public $observacoes_internas;
		public $condicao_de_pagamento;
		public $quitado;
		public $comissao_da_imobiliaria;
		public $informacoes_documentacao;
		public $dormitorio;
		public $suite;
		public $suite_c_closet;
		public $demi_suite;
		public $sala;
		public $sala_de_estar;
		public $sala_de_tv;
		public $garagem;
		public $garagem_descoberta;
		public $banheiro;
		public $andar;
		public $elevador;
		public $edicula;
		public $horta;
		public $jardim;
		public $area_de_servico;
		public $bar;
		public $biblioteca;
		public $closet;
		public $copa;
		public $despensa;
		public $escritorio;
		public $lareira;
		public $sala_de_ginastica;
		public $sala_de_jantar;
		public $acesso_a_deficiente;
		public $gerador_de_energia;
		public $guarita;
		public $lavanderia_coletiva;
		public $medicao;
		public $agua_individual;
		public $portaria_24_horas;
		public $bicicletario;
		public $churrasqueira;
		public $ducha_externa;
		public $piscina;
		public $playground;
		public $quadra_de_esportes;
		public $quadra_tenis;
		public $sala_ginastica_fitness;
		public $salao_de_festas;
		public $salao_de_jogos;
		public $sauna;
		public $alarme;
		public $camera_de_vigilancia;
		public $fechadura_reforcada;
		public $interfone;
		public $muro_com_cerca_eletrica;
		public $portao_eletronico;
		public $vigilancia_24_horas;
		public $id_imobiliaria;
		public $data_criacao;

		public $gerenciadorImobiliarioUsuarioID;

        // Db connection
        public function __construct($db){
            $this->conn = $db;
        }

        // GET ALL
        public function getImovel(){
			$usuarioID = (int)$this->gerenciadorImobiliarioUsuarioID;
			
            $sqlQuery = "
				SELECT
					imobiliarias.id_user as userID,
					imoveis.id,
					imoveis.angariador_corretor,
					imoveis.proprietario,
					imoveis.titulo,
					imoveis.situacao,
					imoveis.categoria,
					imoveis.valor,
					imoveis.indice_de_reajuste_ao_consumidor,
					imoveis.area_total,
					imoveis.indice_cadastral,
					imoveis.construtora,
					imoveis.idade,
					imoveis.posicao,
					imoveis.topografia,
					imoveis.taxa_do_condominio,
					imoveis.iptu,
					imoveis.permuta,
					imoveis.imovel_ocupado,
					imoveis.rua,
					imoveis.numero,
					imoveis.bairro,
					imoveis.estado,
					imoveis.cidade,
					imoveis.descricao_do_imovel,
					imoveis.observacoes_internas,
					imoveis.condicao_de_pagamento,
					imoveis.quitado,
					imoveis.comissao_da_imobiliaria,
					imoveis.informacoes_documentacao,
					imoveis.dormitorio,
					imoveis.suite,
					imoveis.suite_c_closet,
					imoveis.demi_suite,
					imoveis.sala,
					imoveis.sala_de_estar,
					imoveis.sala_de_tv,
					imoveis.garagem,
					imoveis.garagem_descoberta,
					imoveis.banheiro,
					imoveis.andar,
					imoveis.elevador,
					imoveis.edicula,
					imoveis.horta,
					imoveis.jardim,
					imoveis.area_de_servico,
					imoveis.bar,
					imoveis.biblioteca,
					imoveis.closet,
					imoveis.copa,
					imoveis.despensa,
					imoveis.escritorio,
					imoveis.lareira,
					imoveis.sala_de_ginastica,
					imoveis.sala_de_jantar,
					imoveis.acesso_a_deficiente,
					imoveis.gerador_de_energia,
					imoveis.guarita,
					imoveis.lavanderia_coletiva,
					imoveis.medicao,
					imoveis.agua_individual,
					imoveis.portaria_24_horas,
					imoveis.bicicletario,
					imoveis.churrasqueira,
					imoveis.ducha_externa,
					imoveis.piscina,
					imoveis.playground,
					imoveis.quadra_de_esportes,
					imoveis.quadra_tenis,
					imoveis.sala_ginastica_fitness,
					imoveis.salao_de_festas,
					imoveis.salao_de_jogos,
					imoveis.sauna,
					imoveis.alarme,
					imoveis.camera_de_vigilancia,
					imoveis.fechadura_reforcada,
					imoveis.interfone,
					imoveis.muro_com_cerca_eletrica,
					imoveis.portao_eletronico,
					imoveis.vigilancia_24_horas,
					imoveis.id_imobiliaria,
					imoveis.data_criacao
				FROM
					imoveis,
					imobiliarias
				WHERE
					imoveis.id_imobiliaria = imobiliarias.id_user AND
					imobiliarias.id_user = $usuarioID
			";
            $stmt = $this->conn->prepare($sqlQuery);
            $stmt->execute();
            return $stmt;
        }

  
        // CAPTURA IMOVEL PELO ID
        public function getImovelID(){
			
			$itemID = (int)$this->id;
            $sqlQuery = "SELECT
                        *
                      FROM
                        ". $this->db_table ."
                    WHERE 
                       id = ?
                    LIMIT 0,1";

            $stmt = $this->conn->prepare($sqlQuery);
            $stmt->bindParam(1, $this->id);
            $stmt->execute();
            $dataRow = $stmt->fetch(PDO::FETCH_ASSOC);
			

			//captura ID do usuario
            $sqlQueryiduSUARIO = "
				SELECT
					imobiliarias.id_user as userID
				FROM
					imobiliarias
				WHERE
					imobiliarias.id = '{$dataRow['id_imobiliaria']}'
			";
            $dadosUsuarioQ = $this->conn->prepare($sqlQueryiduSUARIO);
            $dadosUsuarioQ->execute();
 			$dadosUsuario = $dadosUsuarioQ->fetch(PDO::FETCH_ASSOC);

			//captura ID do usuario
			$this->id = $dataRow['id'];
			$this->userID = $dadosUsuario['userID'];
			$this->angariador_corretor = $dataRow['angariador_corretor'];
			$this->proprietario = $dataRow['proprietario'];
			$this->titulo = $dataRow['titulo'];
			$this->situacao = $dataRow['situacao'];
			$this->categoria = $dataRow['categoria'];
			$this->valor = $dataRow['valor'];
			$this->indice_de_reajuste_ao_consumidor = $dataRow['indice_de_reajuste_ao_consumidor'];
			$this->area_total = $dataRow['area_total'];
			$this->indice_cadastral = $dataRow['indice_cadastral'];
			$this->construtora = $dataRow['construtora'];
			$this->idade = $dataRow['idade'];
			$this->posicao = $dataRow['posicao'];
			$this->topografia = $dataRow['topografia'];
			$this->taxa_do_condominio = $dataRow['taxa_do_condominio'];
			$this->iptu = $dataRow['iptu'];
			$this->permuta = $dataRow['permuta'];
			$this->imovel_ocupado = $dataRow['imovel_ocupado'];
			$this->rua = $dataRow['rua'];
			$this->numero = $dataRow['numero'];
			$this->bairro = $dataRow['bairro'];
			$this->estado = $dataRow['estado'];
			$this->cidade = $dataRow['cidade'];
			$this->descricao_do_imovel = $dataRow['descricao_do_imovel'];
			$this->observacoes_internas = $dataRow['observacoes_internas'];
			$this->condicao_de_pagamento = $dataRow['condicao_de_pagamento'];
			$this->quitado = $dataRow['quitado'];
			$this->comissao_da_imobiliaria = $dataRow['comissao_da_imobiliaria'];
			$this->informacoes_documentacao = $dataRow['informacoes_documentacao'];
			$this->dormitorio = $dataRow['dormitorio'];
			$this->suite = $dataRow['suite'];
			$this->suite_c_closet = $dataRow['suite_c_closet'];
			$this->demi_suite = $dataRow['demi_suite'];
			$this->sala = $dataRow['sala'];
			$this->sala_de_estar = $dataRow['sala_de_estar'];
			$this->sala_de_tv = $dataRow['sala_de_tv'];
			$this->garagem = $dataRow['garagem'];
			$this->garagem_descoberta = $dataRow['garagem_descoberta'];
			$this->banheiro = $dataRow['banheiro'];
			$this->andar = $dataRow['andar'];
			$this->elevador = $dataRow['elevador'];
			$this->edicula = $dataRow['edicula'];
			$this->horta = $dataRow['horta'];
			$this->jardim = $dataRow['jardim'];
			$this->area_de_servico = $dataRow['area_de_servico'];
			$this->bar = $dataRow['bar'];
			$this->biblioteca = $dataRow['biblioteca'];
			$this->closet = $dataRow['closet'];
			$this->copa = $dataRow['copa'];
			$this->despensa = $dataRow['despensa'];
			$this->escritorio = $dataRow['escritorio'];
			$this->lareira = $dataRow['lareira'];
			$this->sala_de_ginastica = $dataRow['sala_de_ginastica'];
			$this->sala_de_jantar = $dataRow['sala_de_jantar'];
			$this->acesso_a_deficiente = $dataRow['acesso_a_deficiente'];
			$this->gerador_de_energia = $dataRow['gerador_de_energia'];
			$this->guarita = $dataRow['guarita'];
			$this->lavanderia_coletiva = $dataRow['lavanderia_coletiva'];
			$this->medicao = $dataRow['medicao'];
			$this->agua_individual = $dataRow['agua_individual'];
			$this->portaria_24_horas = $dataRow['portaria_24_horas'];
			$this->bicicletario = $dataRow['bicicletario'];
			$this->churrasqueira = $dataRow['churrasqueira'];
			$this->ducha_externa = $dataRow['ducha_externa'];
			$this->piscina = $dataRow['piscina'];
			$this->playground = $dataRow['playground'];
			$this->quadra_de_esportes = $dataRow['quadra_de_esportes'];
			$this->quadra_tenis = $dataRow['quadra_tenis'];
			$this->sala_ginastica_fitness = $dataRow['sala_ginastica_fitness'];
			$this->salao_de_festas = $dataRow['salao_de_festas'];
			$this->salao_de_jogos = $dataRow['salao_de_jogos'];
			$this->sauna = $dataRow['sauna'];
			$this->alarme = $dataRow['alarme'];
			$this->camera_de_vigilancia = $dataRow['camera_de_vigilancia'];
			$this->fechadura_reforcada = $dataRow['fechadura_reforcada'];
			$this->interfone = $dataRow['interfone'];
			$this->muro_com_cerca_eletrica = $dataRow['muro_com_cerca_eletrica'];
			$this->portao_eletronico = $dataRow['portao_eletronico'];
			$this->vigilancia_24_horas = $dataRow['vigilancia_24_horas'];
			$this->id_imobiliaria = $dataRow['id_imobiliaria'];
			$this->data_criacao = $dataRow['data_criacao'];

         }        


 
		//CADASTRA IMOVEL
        public function cadastraImovel(){
            $sqlQuery = "
				INSERT INTO
                        ". $this->db_table ."
				SET
 					
					titulo = :titulo, 
					situacao = :situacao, 
					categoria = :categoria, 
					valor = :valor, 
					indice_de_reajuste_ao_consumidor = :indice_de_reajuste_ao_consumidor, 
					area_total = :area_total, 
					indice_cadastral = :indice_cadastral, 
					construtora = :construtora, 
					idade = :idade, 
					posicao = :posicao, 
					topografia = :topografia, 
					taxa_do_condominio = :taxa_do_condominio, 
					iptu = :iptu, 
					permuta = :permuta, 
					imovel_ocupado = :imovel_ocupado, 
					rua = :rua, 
					numero = :numero, 
					bairro = :bairro, 
					estado = :estado, 
					cidade = :cidade, 
					descricao_do_imovel = :descricao_do_imovel, 
					observacoes_internas = :observacoes_internas, 
					condicao_de_pagamento = :condicao_de_pagamento, 
					quitado = :quitado, 
					comissao_da_imobiliaria = :comissao_da_imobiliaria, 
					informacoes_documentacao = :informacoes_documentacao, 
					dormitorio = :dormitorio, 
					suite = :suite, 
					suite_c_closet = :suite_c_closet, 
					demi_suite = :demi_suite, 
					sala = :sala, 
					sala_de_estar = :sala_de_estar, 
					sala_de_tv = :sala_de_tv, 
					garagem = :garagem, 
					garagem_descoberta = :garagem_descoberta, 
					banheiro = :banheiro, 
					andar = :andar, 
					elevador = :elevador, 
					edicula = :edicula, 
					horta = :horta, 
					jardim = :jardim, 
					area_de_servico = :area_de_servico, 
					bar = :bar, 
					biblioteca = :biblioteca, 
					closet = :closet, 
					copa = :copa, 
					despensa = :despensa, 
					escritorio = :escritorio, 
					lareira = :lareira, 
					sala_de_ginastica = :sala_de_ginastica, 
					sala_de_jantar = :sala_de_jantar, 
					acesso_a_deficiente = :acesso_a_deficiente, 
					gerador_de_energia = :gerador_de_energia, 
					guarita = :guarita, 
					lavanderia_coletiva = :lavanderia_coletiva, 
					medicao = :medicao, 
					agua_individual = :agua_individual, 
					portaria_24_horas = :portaria_24_horas, 
					bicicletario = :bicicletario, 
					churrasqueira = :churrasqueira, 
					ducha_externa = :ducha_externa, 
					piscina = :piscina, 
					playground = :playground, 
					quadra_de_esportes = :quadra_de_esportes, 
					quadra_tenis = :quadra_tenis, 
					sala_ginastica_fitness = :sala_ginastica_fitness, 
					salao_de_festas = :salao_de_festas, 
					salao_de_jogos = :salao_de_jogos, 
					sauna = :sauna, 
					alarme = :alarme, 
					camera_de_vigilancia = :camera_de_vigilancia, 
					fechadura_reforcada = :fechadura_reforcada, 
					interfone = :interfone, 
					muro_com_cerca_eletrica = :muro_com_cerca_eletrica, 
					portao_eletronico = :portao_eletronico, 
					vigilancia_24_horas = :vigilancia_24_horas, 
					id_imobiliaria = :id_imobiliaria, 
					data_criacao = :data_criacao
			";
			
				try {
			            $stmt = $this->conn->prepare($sqlQuery);

			            // bind data
			            //$stmt->bindParam(":name", $this->name);
						 
						
						$destaque = 0;
						$valor = str_replace('.', '', $this->valor);
						$valor = str_replace(',', '.', $valor);
						$taxa_do_condominio = str_replace('.', '', $this->taxa_do_condominio);
						$taxa_do_condominio = str_replace(',', '.', $taxa_do_condominio);

						$dataCadastro = date("Y-m-d H:i:s");
						$codigo   = uniqid(time().'.'.rand(), true);
						//$stmt->bindParam(':usuario_id' , $_SESSION['userID'], PDO::PARAM_STR);
						//$stmt->bindParam(':codigo' , $codigo, PDO::PARAM_STR);
						$stmt->bindParam(':titulo' , $this->titulo, PDO::PARAM_STR);
						$stmt->bindParam(':situacao' , $this->situacao, PDO::PARAM_STR);
						$stmt->bindParam(':categoria' , $this->categoria, PDO::PARAM_STR);
						$stmt->bindParam(':valor' , $valor, PDO::PARAM_STR);
						$stmt->bindParam(':indice_de_reajuste_ao_consumidor' , $this->indice_de_reajuste_ao_consumidor, PDO::PARAM_STR);
						$stmt->bindParam(':area_total' , $this->area_total, PDO::PARAM_STR);
						$stmt->bindParam(':indice_cadastral' , $this->indice_cadastral, PDO::PARAM_STR);
						$stmt->bindParam(':construtora' , $this->construtora, PDO::PARAM_STR);
						$stmt->bindParam(':idade' , $this->idade, PDO::PARAM_STR);
						$stmt->bindParam(':posicao' , $this->posicao, PDO::PARAM_STR);
						$stmt->bindParam(':topografia' , $this->topografia, PDO::PARAM_STR);
						$stmt->bindParam(':taxa_do_condominio' , $taxa_do_condominio, PDO::PARAM_STR);
						$stmt->bindParam(':iptu' , $this->iptu, PDO::PARAM_STR);
						$stmt->bindParam(':permuta' , $this->permuta, PDO::PARAM_STR);
						$stmt->bindParam(':imovel_ocupado' , $this->imovel_ocupado, PDO::PARAM_STR);
						$stmt->bindParam(':rua' , $this->rua, PDO::PARAM_STR);
						$stmt->bindParam(':numero' , $this->numero, PDO::PARAM_STR);
						$stmt->bindParam(':bairro' , $this->bairro, PDO::PARAM_STR);
						$stmt->bindParam(':estado' , $this->estado, PDO::PARAM_STR);
						$stmt->bindParam(':cidade' , $this->cidade, PDO::PARAM_STR);
						$stmt->bindParam(':descricao_do_imovel' , $this->descricao_do_imovel, PDO::PARAM_STR);
						$stmt->bindParam(':observacoes_internas' , $this->observacoes_internas, PDO::PARAM_STR);
						$stmt->bindParam(':condicao_de_pagamento' , $this->condicao_de_pagamento, PDO::PARAM_STR);
						$stmt->bindParam(':quitado' , $this->quitado, PDO::PARAM_STR);
						$stmt->bindParam(':comissao_da_imobiliaria' , $this->comissao_da_imobiliaria, PDO::PARAM_STR);
						$stmt->bindParam(':informacoes_documentacao' , $this->informacoes_documentacao, PDO::PARAM_STR);
						$stmt->bindParam(':dormitorio' , $this->dormitorio, PDO::PARAM_STR);
						$stmt->bindParam(':suite' , $this->suite, PDO::PARAM_STR);
						$stmt->bindParam(':suite_c_closet' , $this->suite_c_closet, PDO::PARAM_STR);
						$stmt->bindParam(':demi_suite' , $this->demi_suite, PDO::PARAM_STR);
						$stmt->bindParam(':sala' , $this->sala, PDO::PARAM_STR);
						$stmt->bindParam(':sala_de_estar' , $this->sala_de_estar, PDO::PARAM_STR);
						$stmt->bindParam(':sala_de_tv' , $this->sala_de_tv, PDO::PARAM_STR);
						$stmt->bindParam(':garagem' , $this->garagem, PDO::PARAM_STR);
						$stmt->bindParam(':garagem_descoberta' , $this->garagem_descoberta, PDO::PARAM_STR);
						$stmt->bindParam(':banheiro' , $this->banheiro, PDO::PARAM_STR);
						$stmt->bindParam(':andar' , $this->andar, PDO::PARAM_STR);
						$stmt->bindParam(':elevador' , $this->elevador, PDO::PARAM_STR);
						$stmt->bindParam(':edicula' , $this->edicula, PDO::PARAM_STR);
						$stmt->bindParam(':horta' , $this->horta, PDO::PARAM_STR);
						$stmt->bindParam(':jardim' , $this->jardim, PDO::PARAM_STR);
						$stmt->bindParam(':area_de_servico' , $this->area_de_servico, PDO::PARAM_STR);
						$stmt->bindParam(':bar' , $this->bar, PDO::PARAM_STR);
						$stmt->bindParam(':biblioteca' , $this->biblioteca, PDO::PARAM_STR);
						$stmt->bindParam(':closet' , $this->closet, PDO::PARAM_STR);
						$stmt->bindParam(':copa' , $this->copa, PDO::PARAM_STR);
						$stmt->bindParam(':despensa' , $this->despensa, PDO::PARAM_STR);
						$stmt->bindParam(':escritorio' , $this->escritorio, PDO::PARAM_STR);
						$stmt->bindParam(':lareira' , $this->lareira, PDO::PARAM_STR);
						$stmt->bindParam(':sala_de_ginastica' , $this->sala_de_ginastica, PDO::PARAM_STR);
						$stmt->bindParam(':sala_de_jantar' , $this->sala_de_jantar, PDO::PARAM_STR);
						$stmt->bindParam(':acesso_a_deficiente' , $this->acesso_a_deficiente, PDO::PARAM_STR);
						$stmt->bindParam(':gerador_de_energia' , $this->gerador_de_energia, PDO::PARAM_STR);
						$stmt->bindParam(':guarita' , $this->guarita, PDO::PARAM_STR);
						$stmt->bindParam(':lavanderia_coletiva' , $this->lavanderia_coletiva, PDO::PARAM_STR);
						$stmt->bindParam(':medicao' , $this->medicao, PDO::PARAM_STR);
						$stmt->bindParam(':agua_individual' , $this->agua_individual, PDO::PARAM_STR);
						$stmt->bindParam(':portaria_24_horas' , $this->portaria_24_horas, PDO::PARAM_STR);
						$stmt->bindParam(':bicicletario' , $this->bicicletario, PDO::PARAM_STR);
						$stmt->bindParam(':churrasqueira' , $this->churrasqueira, PDO::PARAM_STR);
						$stmt->bindParam(':ducha_externa' , $this->ducha_externa, PDO::PARAM_STR);
						$stmt->bindParam(':piscina' , $this->piscina, PDO::PARAM_STR);
						$stmt->bindParam(':playground' , $this->playground, PDO::PARAM_STR);
						$stmt->bindParam(':quadra_de_esportes' , $this->quadra_de_esportes, PDO::PARAM_STR);
						$stmt->bindParam(':quadra_tenis' , $this->quadra_tenis, PDO::PARAM_STR);
						$stmt->bindParam(':sala_ginastica_fitness' , $this->sala_ginastica_fitness, PDO::PARAM_STR);
						$stmt->bindParam(':salao_de_festas' , $this->salao_de_festas, PDO::PARAM_STR);
						$stmt->bindParam(':salao_de_jogos' , $this->salao_de_jogos, PDO::PARAM_STR);
						$stmt->bindParam(':sauna' , $this->sauna, PDO::PARAM_STR);
						$stmt->bindParam(':alarme' , $this->alarme, PDO::PARAM_STR);
						$stmt->bindParam(':camera_de_vigilancia' , $this->camera_de_vigilancia, PDO::PARAM_STR);
						$stmt->bindParam(':fechadura_reforcada' , $this->fechadura_reforcada, PDO::PARAM_STR);
						$stmt->bindParam(':interfone' , $this->interfone, PDO::PARAM_STR);
						$stmt->bindParam(':muro_com_cerca_eletrica' , $this->muro_com_cerca_eletrica, PDO::PARAM_STR);
						$stmt->bindParam(':portao_eletronico' , $this->portao_eletronico, PDO::PARAM_STR);
						$stmt->bindParam(':vigilancia_24_horas' , $this->vigilancia_24_horas, PDO::PARAM_STR);
						$stmt->bindParam(':id_imobiliaria' , $this->imobiliariaID, PDO::PARAM_STR);
						$stmt->bindParam(':data_criacao' , $dataCadastro, PDO::PARAM_STR);
						
						
			            if($stmt->execute()){
							$id_imovel = $this->conn->lastInsertId();
							return $id_imovel;
			            }
						else
						{
							return false;
						}
				}
				catch(PDOException $e) {
					echo $e;
				}
        }





 
		//ATUALIZA IMOVEL
        public function atualizaImovel(){

			$gerenciadorImovelID = (int)$this->gerenciadorImovelIDCorreto;
            $sqlQueryC = "
            	SELECT
                       *
                  FROM
                    ". $this->db_table ."
                WHERE 
                   id = ?
                LIMIT 0,1
            ";

            $stmt = $this->conn->prepare($sqlQueryC);
            $stmt->bindParam(1, $gerenciadorImovelID);
            $stmt->execute();
            $dadosImovelGerenciador = $stmt->fetch(PDO::FETCH_ASSOC);
			 

            $sqlQuery = "
					UPDATE
						". $this->db_table ."
					set
						titulo = :titulo ,
						situacao = :situacao ,
						categoria = :categoria ,
						valor = :valor ,
						indice_de_reajuste_ao_consumidor = :indice_de_reajuste_ao_consumidor ,
						area_total = :area_total ,
						indice_cadastral = :indice_cadastral ,
						construtora = :construtora ,
						idade = :idade ,
						posicao = :posicao ,
						topografia = :topografia ,
						taxa_do_condominio = :taxa_do_condominio ,
						iptu = :iptu ,
						permuta = :permuta ,
						imovel_ocupado = :imovel_ocupado ,
						rua = :rua ,
						numero = :numero ,
						bairro = :bairro ,
						estado = :estado ,
						cidade = :cidade ,
						descricao_do_imovel = :descricao_do_imovel ,
						observacoes_internas = :observacoes_internas ,
						condicao_de_pagamento = :condicao_de_pagamento ,
						quitado = :quitado ,
						comissao_da_imobiliaria = :comissao_da_imobiliaria ,
						informacoes_documentacao = :informacoes_documentacao ,
						dormitorio = :dormitorio ,
						suite = :suite ,
						suite_c_closet = :suite_c_closet ,
						demi_suite = :demi_suite ,
						sala = :sala ,
						sala_de_estar = :sala_de_estar ,
						sala_de_tv = :sala_de_tv ,
						garagem = :garagem ,
						garagem_descoberta = :garagem_descoberta ,
						banheiro = :banheiro ,
						andar = :andar ,
						elevador = :elevador ,
						edicula = :edicula ,
						horta = :horta ,
						jardim = :jardim ,
						area_de_servico = :area_de_servico ,
						bar = :bar ,
						biblioteca = :biblioteca ,
						closet = :closet ,
						copa = :copa ,
						despensa = :despensa ,
						escritorio = :escritorio ,
						lareira = :lareira ,
						sala_de_ginastica = :sala_de_ginastica ,
						sala_de_jantar = :sala_de_jantar ,
						acesso_a_deficiente = :acesso_a_deficiente ,
						gerador_de_energia = :gerador_de_energia ,
						guarita = :guarita ,
						lavanderia_coletiva = :lavanderia_coletiva ,
						medicao = :medicao ,
						agua_individual = :agua_individual ,
						portaria_24_horas = :portaria_24_horas ,
						bicicletario = :bicicletario ,
						churrasqueira = :churrasqueira ,
						ducha_externa = :ducha_externa ,
						piscina = :piscina ,
						playground = :playground ,
						quadra_de_esportes = :quadra_de_esportes ,
						quadra_tenis = :quadra_tenis ,
						sala_ginastica_fitness = :sala_ginastica_fitness ,
						salao_de_festas = :salao_de_festas ,
						salao_de_jogos = :salao_de_jogos ,
						sauna = :sauna ,
						alarme = :alarme ,
						camera_de_vigilancia = :camera_de_vigilancia ,
						fechadura_reforcada = :fechadura_reforcada ,
						interfone = :interfone ,
						muro_com_cerca_eletrica = :muro_com_cerca_eletrica ,
						portao_eletronico = :portao_eletronico,
						vigilancia_24_horas = :vigilancia_24_horas 
					where
						id = :gerenciadorImovelID and
						id_imobiliaria = :gerenciadorImobiliariaID
			";
			
				try {
			            $stmt = $this->conn->prepare($sqlQuery); 

						$destaque = 0;
						$valor = str_replace('.', '', $this->valor);
						$valor = str_replace(',', '.', $valor);
						$taxa_do_condominio = str_replace('.', '', $this->taxa_do_condominio);
						$taxa_do_condominio = str_replace(',', '.', $taxa_do_condominio);

						$dataCadastro = date("Y-m-d H:i:s");
						$codigo   = uniqid(time().'.'.rand(), true); 
						$stmt->bindParam(':titulo' , $this->titulo, PDO::PARAM_STR);
						$stmt->bindParam(':situacao' , $this->situacao, PDO::PARAM_STR);
						$stmt->bindParam(':categoria' , $this->categoria, PDO::PARAM_STR);
						$stmt->bindParam(':valor' , $valor, PDO::PARAM_STR);
						$stmt->bindParam(':indice_de_reajuste_ao_consumidor' , $this->indice_de_reajuste_ao_consumidor, PDO::PARAM_STR);
						$stmt->bindParam(':area_total' , $this->area_total, PDO::PARAM_STR);
						$stmt->bindParam(':indice_cadastral' , $this->indice_cadastral, PDO::PARAM_STR);
						$stmt->bindParam(':construtora' , $this->construtora, PDO::PARAM_STR);
						$stmt->bindParam(':idade' , $this->idade, PDO::PARAM_STR);
						$stmt->bindParam(':posicao' , $this->posicao, PDO::PARAM_STR);
						$stmt->bindParam(':topografia' , $this->topografia, PDO::PARAM_STR);
						$stmt->bindParam(':taxa_do_condominio' , $taxa_do_condominio, PDO::PARAM_STR);
						$stmt->bindParam(':iptu' , $this->iptu, PDO::PARAM_STR);
						$stmt->bindParam(':permuta' , $this->permuta, PDO::PARAM_STR);
						$stmt->bindParam(':imovel_ocupado' , $this->imovel_ocupado, PDO::PARAM_STR);
						$stmt->bindParam(':rua' , $this->rua, PDO::PARAM_STR);
						$stmt->bindParam(':numero' , $this->numero, PDO::PARAM_STR);
						$stmt->bindParam(':bairro' , $this->bairro, PDO::PARAM_STR);
						$stmt->bindParam(':estado' , $this->estado, PDO::PARAM_STR);
						$stmt->bindParam(':cidade' , $this->cidade, PDO::PARAM_STR);
						$stmt->bindParam(':descricao_do_imovel' , $this->descricao_do_imovel, PDO::PARAM_STR);
						$stmt->bindParam(':observacoes_internas' , $this->observacoes_internas, PDO::PARAM_STR);
						$stmt->bindParam(':condicao_de_pagamento' , $this->condicao_de_pagamento, PDO::PARAM_STR);
						$stmt->bindParam(':quitado' , $this->quitado, PDO::PARAM_STR);
						$stmt->bindParam(':comissao_da_imobiliaria' , $this->comissao_da_imobiliaria, PDO::PARAM_STR);
						$stmt->bindParam(':informacoes_documentacao' , $this->informacoes_documentacao, PDO::PARAM_STR);
						$stmt->bindParam(':dormitorio' , $this->dormitorio, PDO::PARAM_STR);
						$stmt->bindParam(':suite' , $this->suite, PDO::PARAM_STR);
						$stmt->bindParam(':suite_c_closet' , $this->suite_c_closet, PDO::PARAM_STR);
						$stmt->bindParam(':demi_suite' , $this->demi_suite, PDO::PARAM_STR);
						$stmt->bindParam(':sala' , $this->sala, PDO::PARAM_STR);
						$stmt->bindParam(':sala_de_estar' , $this->sala_de_estar, PDO::PARAM_STR);
						$stmt->bindParam(':sala_de_tv' , $this->sala_de_tv, PDO::PARAM_STR);
						$stmt->bindParam(':garagem' , $this->garagem, PDO::PARAM_STR);
						$stmt->bindParam(':garagem_descoberta' , $this->garagem_descoberta, PDO::PARAM_STR);
						$stmt->bindParam(':banheiro' , $this->banheiro, PDO::PARAM_STR);
						$stmt->bindParam(':andar' , $this->andar, PDO::PARAM_STR);
						$stmt->bindParam(':elevador' , $this->elevador, PDO::PARAM_STR);
						$stmt->bindParam(':edicula' , $this->edicula, PDO::PARAM_STR);
						$stmt->bindParam(':horta' , $this->horta, PDO::PARAM_STR);
						$stmt->bindParam(':jardim' , $this->jardim, PDO::PARAM_STR);
						$stmt->bindParam(':area_de_servico' , $this->area_de_servico, PDO::PARAM_STR);
						$stmt->bindParam(':bar' , $this->bar, PDO::PARAM_STR);
						$stmt->bindParam(':biblioteca' , $this->biblioteca, PDO::PARAM_STR);
						$stmt->bindParam(':closet' , $this->closet, PDO::PARAM_STR);
						$stmt->bindParam(':copa' , $this->copa, PDO::PARAM_STR);
						$stmt->bindParam(':despensa' , $this->despensa, PDO::PARAM_STR);
						$stmt->bindParam(':escritorio' , $this->escritorio, PDO::PARAM_STR);
						$stmt->bindParam(':lareira' , $this->lareira, PDO::PARAM_STR);
						$stmt->bindParam(':sala_de_ginastica' , $this->sala_de_ginastica, PDO::PARAM_STR);
						$stmt->bindParam(':sala_de_jantar' , $this->sala_de_jantar, PDO::PARAM_STR);
						$stmt->bindParam(':acesso_a_deficiente' , $this->acesso_a_deficiente, PDO::PARAM_STR);
						$stmt->bindParam(':gerador_de_energia' , $this->gerador_de_energia, PDO::PARAM_STR);
						$stmt->bindParam(':guarita' , $this->guarita, PDO::PARAM_STR);
						$stmt->bindParam(':lavanderia_coletiva' , $this->lavanderia_coletiva, PDO::PARAM_STR);
						$stmt->bindParam(':medicao' , $this->medicao, PDO::PARAM_STR);
						$stmt->bindParam(':agua_individual' , $this->agua_individual, PDO::PARAM_STR);
						$stmt->bindParam(':portaria_24_horas' , $this->portaria_24_horas, PDO::PARAM_STR);
						$stmt->bindParam(':bicicletario' , $this->bicicletario, PDO::PARAM_STR);
						$stmt->bindParam(':churrasqueira' , $this->churrasqueira, PDO::PARAM_STR);
						$stmt->bindParam(':ducha_externa' , $this->ducha_externa, PDO::PARAM_STR);
						$stmt->bindParam(':piscina' , $this->piscina, PDO::PARAM_STR);
						$stmt->bindParam(':playground' , $this->playground, PDO::PARAM_STR);
						$stmt->bindParam(':quadra_de_esportes' , $this->quadra_de_esportes, PDO::PARAM_STR);
						$stmt->bindParam(':quadra_tenis' , $this->quadra_tenis, PDO::PARAM_STR);
						$stmt->bindParam(':sala_ginastica_fitness' , $this->sala_ginastica_fitness, PDO::PARAM_STR);
						$stmt->bindParam(':salao_de_festas' , $this->salao_de_festas, PDO::PARAM_STR);
						$stmt->bindParam(':salao_de_jogos' , $this->salao_de_jogos, PDO::PARAM_STR);
						$stmt->bindParam(':sauna' , $this->sauna, PDO::PARAM_STR);
						$stmt->bindParam(':alarme' , $this->alarme, PDO::PARAM_STR);
						$stmt->bindParam(':camera_de_vigilancia' , $this->camera_de_vigilancia, PDO::PARAM_STR);
						$stmt->bindParam(':fechadura_reforcada' , $this->fechadura_reforcada, PDO::PARAM_STR);
						$stmt->bindParam(':interfone' , $this->interfone, PDO::PARAM_STR);
						$stmt->bindParam(':muro_com_cerca_eletrica' , $this->muro_com_cerca_eletrica, PDO::PARAM_STR);
						$stmt->bindParam(':portao_eletronico' , $this->portao_eletronico, PDO::PARAM_STR);
						$stmt->bindParam(':vigilancia_24_horas' , $this->vigilancia_24_horas, PDO::PARAM_STR);
						$stmt->bindParam(':gerenciadorImobiliariaID' , $dadosImovelGerenciador['id_imobiliaria'], PDO::PARAM_STR);
						$stmt->bindParam(':gerenciadorImovelID' , $dadosImovelGerenciador['id'], PDO::PARAM_STR);			
 			            if($stmt->execute()){
			            	 
							return 'sucesso';
			            }
						else
						{
							print_r($stmt->errorInfo());	
							return false;
						}
				}
				catch(PDOException $e) {
					echo $e;
				}
        }






        // UPDATE
        public function updateEmployee(){
            $sqlQuery = "UPDATE
                        ". $this->db_table ."
                    SET
                        name = :name, 
                        email = :email, 
                        age = :age, 
                        designation = :designation, 
                        created = :created
                    WHERE 
                        id = :id";
        
            $stmt = $this->conn->prepare($sqlQuery);
        
            $this->name=htmlspecialchars(strip_tags($this->name));
            $this->email=htmlspecialchars(strip_tags($this->email));
            $this->age=htmlspecialchars(strip_tags($this->age));
            $this->designation=htmlspecialchars(strip_tags($this->designation));
            $this->created=htmlspecialchars(strip_tags($this->created));
            $this->id=htmlspecialchars(strip_tags($this->id));
        
            // bind data
            $stmt->bindParam(":name", $this->name);
            $stmt->bindParam(":email", $this->email);
            $stmt->bindParam(":age", $this->age);
            $stmt->bindParam(":designation", $this->designation);
            $stmt->bindParam(":created", $this->created);
            $stmt->bindParam(":id", $this->id);
        
            if($stmt->execute()){
               return true;
            }
            return false;
        }








        // DELETE
        function deleteEmployee(){
            $sqlQuery = "DELETE FROM " . $this->db_table . " WHERE id = ?";
            $stmt = $this->conn->prepare($sqlQuery);
        
            $this->id=htmlspecialchars(strip_tags($this->id));
        
            $stmt->bindParam(1, $this->id);
        
            if($stmt->execute()){
                return true;
            }
            return false;
        }

    }
?>

