<?php
require '../bootstrap.php';
$conectDB = connectDB();
$conectDB->exec("set names utf8mb4");


require '../libs/RDSImage.php';
 

$dataCadastro = date("Y-m-d H:i:s");

$dadosUsuario = findItem($conectDB, 'usuario', ' * ', array("code"=>$_SESSION['userCode']) );
if(empty($dadosUsuario->id))
{
	echo messageJson('erro', 'Faça Login');exit;
	exit;
}

$configuracoesSite = findItem($conectDB, 'site', ' * ', array("usuario_id"=>$_SESSION['userID']) );

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $destinoImagens = '../../assets/storage/'.$_SESSION['userCode'].'/corretores/';
        if (!file_exists( $destinoImagens )) {
            mkdir( $destinoImagens, 0777, true);
        }

            //upload image profile
            if (!empty($_FILES['foto']))
            {
                $error      = array();
                $extension  = array("jpeg","jpg","png","gif","webp");
                
                $file_name =$_FILES["foto"]["name"];
                $file_tmp  =$_FILES["foto"]["tmp_name"];
                if(!empty($_FILES['foto']['name'])){
                    if($_FILES['foto']['size'] > 0)
                    {
                        $ext=pathinfo($file_name,PATHINFO_EXTENSION);
                        if(in_array($ext, $extension))
                        {
                            $filename       = basename($file_name,$ext);
                            $newFileName    = $_SESSION['userCode'].'.'.uniqid(time(), true).".". $ext;
                            
                            if(move_uploaded_file($file_tmp, $destinoImagens.$newFileName))
                            {
                                $maxDim = 500;
                                $arquivoRedimensiona = $destinoImagens.$newFileName;
                                list($width, $height, $type, $attr) = getimagesize( $arquivoRedimensiona );
                                if ( $width > $maxDim || $height > $maxDim ){
                                    $target_filename = $arquivoRedimensiona;
                                    $ratio = $width/$height;
                                    if( $ratio > 1) {
                                        $new_width = $maxDim;
                                        $new_height = $maxDim/$ratio;
                                    } else {
                                        $new_width = $maxDim*$ratio;
                                        $new_height = $maxDim;
                                    }
                                    $src = imagecreatefromstring( file_get_contents( $arquivoRedimensiona ) );
                                    $dst = imagecreatetruecolor( $new_width, $new_height );
                                    imagecopyresampled( $dst, $src, 0, 0, 0, 0, $new_width, $new_height, $width, $height );
                                    imagedestroy( $src );
                                    imagepng( $dst, $target_filename ); // adjust format as needed
                                    imagedestroy( $dst );

                                    $foto = $newFileName;
                                }
                            }
                        }
                    }
                }
            }


    $cadinsert = "
        UPDATE
            corretor
        set
            nome = :nome ,
            email = :email ,
            celular = :celular ,
            foto = :foto
        where
            id = :corretorID and
            usuario_id = :usuario_id
     ";
    try {
        $nome        = stringInputCleaner($_POST['nome']);
        $email      = stringInputCleaner($_POST['email']);
        $celular     = stringInputCleaner($_POST['telefone']); 

        $cadresult = $conectDB->prepare($cadinsert);
        $codigo   = uniqid(time().'.'.rand(), true);
        $ativo    = 1;
         
        $cadresult->bindParam(':usuario_id' , $_SESSION['userID'], PDO::PARAM_STR);
        $cadresult->bindParam(':nome' , $nome, PDO::PARAM_STR);
        $cadresult->bindParam(':email' , $email, PDO::PARAM_STR);
        $cadresult->bindParam(':celular' , $celular, PDO::PARAM_STR); 
        $cadresult->bindParam(':foto' , $foto, PDO::PARAM_STR); 
        $cadresult->bindParam(':corretorID' , $_POST['corretorID'], PDO::PARAM_STR); 
        $cadresult->execute();
        $cadcontar = $cadresult->rowCount();
        if($cadcontar > 0) {

 
            //checa conexão com a gerencie sistemas api
            $imovelPost = array();
            //trata post
                foreach($_POST as $coluna => $itemPost){
                    if(!is_array($_POST[$coluna])){
                        if(!empty($itemPost)){
                            $imovelPost[$coluna] = stringInputCleaner($itemPost) ;
                            //echo "$coluna=$itemPost<br>";
                        }
                        else
                        {
                            $imovelPost[$coluna] = $itemPost;
                            //echo "$coluna=$itemPost<br>";
                        }
                    }
                }
            //trata post
            
            if(isset($_POST['sincronizaEdicao'])){
                if( (int)$_POST['sincronizaEdicao'] == 1){
                        $dadosUser = findItem($conectDB, 'usuario', ' gerenciador_imobiliario_token ', array("id"=>$_SESSION['userID']) );

                        if(!empty($dadosUser->gerenciador_imobiliario_token)){
                            $ch = curl_init($configSistema['apiBaseURL'].'corretores/edita');
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                               'Content-Type: application/json',
                               'Authorization: '.$dadosUser->gerenciador_imobiliario_token
                             ));
                            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
                            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
                            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($imovelPost));
                            $data = curl_exec($ch);
                            //print_r($data); 
                            
                            $retorno = json_decode($data);
                             
                            if( (isset($retorno->status)) && ($retorno->status == 'error') )
                            {}
                            else
                            {
                                //print_r( $retorno );
                            }
                        }
                }
            }
        ///////

            echo json_encode(array('sucesso', 'Tudo certo! foi cadastrado com sucesso.', ''));
        }
    }
    catch(PDOException $e) {
        echo $e;
        echo json_encode(array('erro', 'Ops, houve um erro na edição, tente novamente', ''));
    }
}