<?php
require '../bootstrap.php';
$conectDB = connectDB();
$conectDB->exec("set names utf8mb4");

$dataCadastro = date("Y-m-d H:i:s");

$dadosUsuario = findItem($conectDB, 'usuario', ' * ', array("code"=>$_SESSION['userCode']) );
if(empty($dadosUsuario->id))
{
	echo messageJson('erro', 'Faça Login');exit;
	exit;
}
 

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
 
	$dadosUser = findItem($conectDB, 'usuario', ' gerenciador_imobiliario_token ', array("id"=>$_SESSION['userID']) );
	if(empty($dadosUser->gerenciador_imobiliario_token)){
		echo messageJson('erro', 'Informe o seu Token da Gerencie Sistemas para importar corretores');exit;
		exit;
	}

		if(empty($_POST['corretorID']))
		{
			echo messageJson('erro', 'Selecione um ou mais corretores antes de continuar');exit;
			exit;
		}

		$imovelImportado = '';
		foreach($_POST['corretorID'] as $corretorID){
			$token  = $dadosUser->gerenciador_imobiliario_token;
			$ch = curl_init($configSistema['apiBaseURL'].'buscaCorretor/'.$corretorID);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			   'Content-Type: application/json',
			   'Authorization: '.$token
			 ));
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			$data = curl_exec($ch);
			//print_r($data); 
			$retorno = json_decode($data);
			if( (isset($retorno->status)) && ($retorno->status == 'error') )
			{
 				echo messageJson("erro", $retorno->message);
			}
			else
			{
				
				$checaImovelImportado = findItem($conectDB, 'corretor', ' id ', array( "gerencie_corretor_id" => $corretorID ) );
				if( empty($checaImovelImportado->id))
				{
					////encontrou o imovel, cadastra agora
					$dataRetorno = json_decode($data,true);//converts in array
 	 
					$codigo	  = uniqid(time().'.'.rand(), true);
					$ativo 	= 1;
 
					$cadinsert = "
					    INSERT into corretor
					    	(usuario_id, gerencie_corretor_id, codigo, nome, email, celular, foto,  cadastro, ativo)
					    VALUES
					    	(:usuario_id, :gerencie_corretor_id, :codigo, :nome, :email, :celular, :foto, :cadastro, :ativo)";
					try {
						$cadresult = $conectDB->prepare($cadinsert);
						$cadresult->bindParam(':usuario_id' , $_SESSION['userID'], PDO::PARAM_STR);
							$cadresult->bindParam(':gerencie_corretor_id' , $dataRetorno['id'], PDO::PARAM_STR);
							$cadresult->bindParam(':codigo' , $codigo, PDO::PARAM_STR);
						$cadresult->bindParam(':nome' , $dataRetorno['nome'], PDO::PARAM_STR);
						$cadresult->bindParam(':email' , $dataRetorno['email'], PDO::PARAM_STR);
						$cadresult->bindParam(':celular' , $dataRetorno['celular'], PDO::PARAM_STR);
						$cadresult->bindParam(':foto' , $dataRetorno['perfil'], PDO::PARAM_STR);
						$cadresult->bindParam(':cadastro' , $dataRetorno['cadastro'], PDO::PARAM_STR);
						$cadresult->bindParam(':ativo' , $ativo, PDO::PARAM_STR);
						$cadresult->execute();
						$cadcontar = $cadresult->rowCount();
						if($cadcontar > 0) {
								$imovelImportado = 1;
								$id_imovel = $conectDB->lastInsertId();
								//echo 'cadastrou';
								
								//download imagens
									$destino = '../../assets/storage/'.$_SESSION['userCode'].'/corretores/';
									if (!file_exists( $destino )) {
										mkdir( $destino, 0777, true);
									}

									//download image
									if(!empty($dataRetorno['perfil'])){
										$urlImagem 	= 'https://meusistemas.com.br/gerenciador-imobiliario/assets/img/perfils/'.$dataRetorno['perfil'];
										$saveto 	= $destino.$dataRetorno['perfil'];

									    $file = fopen($urlImagem, 'rb');
									    if ($file) {
									        $newf = fopen($saveto, 'wb');
									        if ($newf) {
									            while (!feof($file)) {
									                fwrite($newf, fread($file, 1024 * 8), 1024 * 8);
									            }
									        }
									    }
									    if ($file) {
									        fclose($file);
									    }
									    if ($newf) {
									        fclose($newf);
									    }
									}
 						}
						else
						{
							echo json_encode(array('erro', 'Opss, houve algo de errado e a importação não funcionou, por favor, tente novamente', ''));
						}
					}
					catch(PDOException $e) {
						echo $e;
					}
				}
			}
			if($imovelImportado == 1){
				echo json_encode(array('sucesso', 'Tudo certo! foi cadastrado com sucesso.', ''));
			}
		} 

	
	//$token     = stringInputCleaner($_POST['token']);
}