<?php
require '../bootstrap.php';
$conectDB = connectDB();
$conectDB->exec("set names utf8mb4");

$dataCadastro = date("Y-m-d H:i:s");

$dadosProfessor = findItem($conectDB, 'professor', ' * ', array("code"=>$_SESSION['userCode']) );
if(empty($dadosProfessor->id))
{
	exit;
}


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
	if(empty($_POST['loginEmail'])){
		echo messageJson('erro', 'Informe seu e-mail, é obrigatório');exit;
	}
	else
	{
		if (filter_var($_POST['loginEmail'], FILTER_VALIDATE_EMAIL)) {}else
		{
			echo messageJson('erro', 'O e-mail informado é inválido, informe um e-mail válido');exit;
		}
	}
	 
		$loginEmail    = stringInputCleaner($_POST['loginEmail']);
		$userCode	  = $_SESSION['userCode'];

		$cadinsert = "
			UPDATE
				professor
			SET
				email 	= :email 
			WHERE
				code = :code
		 ";
		try {
			$cadresult = $conectDB->prepare($cadinsert);
			$cadresult->bindParam(':code' , $userCode, PDO::PARAM_STR);
			$cadresult->bindParam(':email', $loginEmail, PDO::PARAM_STR);
			if( $cadresult->execute() ){
				
				$_SESSION['userEmail']	= $loginEmail;
				
				if(!empty($_POST['senhaAtual'])){
					$userPwdPost    = stringInputCleaner($_POST['senhaAtual']);
					
					if(password_verify($userPwdPost, $dadosProfessor->pwd)){
							
							if( (empty($_POST['senha'])) || (empty($_POST['senhaNova2']))){
								echo messageJson('erro', 'Para alterar a sua senha, por favor, informe a nova senha e a confirme', '', '');exit;
							}
							
							if($_POST['senha'] !== $_POST['senhaNova2'])
							{
								echo messageJson('erro', 'As senhas informadas são diferentes, verifique as senhas digitadas', '', '');
							}
							else
							{
								$userPwd     = stringInputCleaner($_POST['senhaNova2']);
								$novaSenha  = password_hash($userPwd, PASSWORD_DEFAULT);
								
								$updatePass = "
									UPDATE
										professor
									SET
										pwd  = :pwd 
									WHERE
										code = :code
								 ";
								$cadUpdatePwd = $conectDB->prepare($updatePass);
								$cadUpdatePwd->bindParam(':code' , $userCode, PDO::PARAM_STR);
								$cadUpdatePwd->bindParam(':pwd' , $novaSenha, PDO::PARAM_STR);
								if( $cadUpdatePwd->execute() )
								{
									enviaEmail($_SESSION['userEmail'], $_SESSION['userName'], 'Você alterou sua senha', $configEmails['informaMudancaSenha'], '', '');

									echo messageJson('sucesso', 'Alterações realizadas com sucesso, por favor, aguarde...', 'redirectToUrl', 'professor/configuracoes');
								}
								else
								{
									echo messageJson('erro', 'houve um erro interno ao tentar alterar sua senha de acesso, por favor, tente novamente', '', '');
								}
							}
							
					}
					else
					{
						echo messageJson('erro', 'A senha atual informada é inválida', '', '');
					}
				}
				else
				{
					echo messageJson('sucesso', 'Alterações realizadas com sucesso, por favor, aguarde...', 'redirectToUrl', 'professor/configuracoes');
				}
			}
			else
			{
				 echo messageJson('sucesso', 'Alterações realizadas ou sem alterações', 'redirectToUrl', 'professor/configuracoes');
			}
		}
		catch(PDOException $e) {
			echo messageJson('erro', 'Houve algo de errado, tente novamente', '', '');
		}
 
}