<?php
require '../bootstrap.php';
$conectDB = connectDB();
$conectDB->exec("set names utf8mb4");

$dataCadastro = date("Y-m-d H:i:s");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

			if(empty($_POST['userEmail'])){
				echo messageJson('erro', 'Informe seu e-mail, é obrigatório');exit;
			}
			else
			{
				if (filter_var($_POST['userEmail'], FILTER_VALIDATE_EMAIL)) {}else
				{
					echo messageJson('erro', 'O e-mail informado é inválido, informe um e-mail válido');exit;
				}
			} 

			$userEmail    = stringInputCleaner($_POST['userEmail']);
 			$userType    = stringInputCleaner($_POST['userType']);


			if( $userType == 1 )//professor
			{
				$usuarioTipo = 1;
				$searchUser  = query($conectDB, 'assoc', "
					select
						cadastro,
						email,
						code,
						id,
						pwd,
						foto,
						nome,
						ativo
					from
						professor
					WHERE
						tipo = 1 and
						email = '".$userEmail."'"
				);
			}
			elseif($userType == 3)//estagiario
			{
				$usuarioTipo = 1;
				$searchUser  = query($conectDB, 'assoc', "
					select
						cadastro,
						email,
						code,
						id,
						pwd,
						foto,
						nome,
						ativo
					from
						professor
					WHERE
						tipo = 3 and
						email = '".$userEmail."'"
				);
			}
			else
			{
				$usuarioTipo = 2;
				$searchUser  = query($conectDB, 'assoc', "
					select
						cadastro,
						email,
						code,
						id,
						pwd,
						foto,
						nome,
						ativo
					from
						escola
					WHERE
						email = '".$userEmail."'"
				);
			}
			if($searchUser == 'error'){
				echo messageJson('erro', 'Houve um erro interno na requisição, tente novamente mais tarde');exit;
			}
			else
			{
			 	if(empty($searchUser[0]['id']))
				{
					echo messageJson('erro', 'Não existe um cadastro com este endereço de e-mail');exit;
				}
				else
				{
					$token = bin2hex(random_bytes(80));
 					$dataExpira = date('Y-m-d H:i:s', strtotime('+60 minutes'));

		       	 	$removeRegisters = "DELETE FROM atualiza_senha WHERE usuario_id=:usuario_id and tipo=:tipo";
		            $removeRegisters = $conectDB->prepare($removeRegisters);
		            $removeRegisters->bindParam(':usuario_id' , $searchUser[0]['id'], PDO::PARAM_STR);
		            $removeRegisters->bindParam(':tipo' , $usuarioTipo, PDO::PARAM_STR);
		            $removeRegisters->execute();


			        $cadinsert = "INSERT into atualiza_senha (usuario_id, tipo, token, expira, cadastro) VALUES (
			        	:usuario_id, :tipo, :token, :expira, :cadastro
			        )";
		            $cadresult = $conectDB->prepare($cadinsert);
		            $cadresult->bindParam(':usuario_id' , 	$searchUser[0]['id'], PDO::PARAM_STR);
		            $cadresult->bindParam(':tipo' , 		$usuarioTipo, PDO::PARAM_STR);
		            $cadresult->bindParam(':token' , 		$token, PDO::PARAM_STR);
		            $cadresult->bindParam(':expira', 	$dataExpira, PDO::PARAM_STR);
		            $cadresult->bindParam(':cadastro', $dataCadastro, PDO::PARAM_STR);
		           	if( $cadresult->execute() )
 					{
						$link 		= BASE.'renova-senha/'.$searchUser[0]['email'].'/'.$token;
						$mensagem	= "
							Você solicitou uma nova senha de acesso ao Localiza prof's.<br>
							Para resetar sua senha clique no link abaixo ou caso não funcione, copie e cole o link em seu navegador.<br>Este link funcionará irá expirar em 60 minutos.<br><br>
							".$link."<br><br>
							Caso não tenha solicitado esta renovação de senha, por favor, desconsidere este email.
						";
						if(enviaEmail($searchUser[0]['email'], $searchUser[0]['nome'], 'Nova Senha de Acesso', $mensagem, $link,'') == 1)
						{
							echo messageJson("sucesso", "Enviamos um email para você, por favor, verifique-o e siga os passos");
						}
						else
						{
							echo messageJson('erro', 'Houve um erro na requisição, tente novamente');exit;
						}

		            }
		            else
		            {
		            	echo messageJson('erro', 'Houve um erro na requisição, tente novamente');exit;
		            }
		        }
	        }
}