<?php
require '../bootstrap.php';
$conectDB = connectDB();

$dataCadastro = date("Y-m-d H:i:s");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

		if(empty($_POST['userName'])){
			echo messageJson('erro', 'Informe seu nome, é obrigatório');exit;
		}
			if(empty($_POST['userEmail'])){
				echo messageJson('erro', 'Informe seu e-mail, é obrigatório');exit;
			}
			else
			{
				if (filter_var($_POST['userEmail'], FILTER_VALIDATE_EMAIL)) {}else
				{
					echo messageJson('erro', 'O e-mail informado é inválido, informe um e-mail válido');exit;
				}
			}
		if( (empty($_POST['password'])) || (empty($_POST['confirmPassword'])) ){
			echo messageJson('erro', 'Informe sua senha, é obrigatório');exit;
		}
			if( $_POST['password'] !== $_POST['confirmPassword'] ){
				echo messageJson('erro', 'As senhas informadas são diferentes');exit;
			}
 
		if(empty($_POST['check'])){
			echo messageJson('erro', 'Aceite os Termos e Condições de uso para continuar');exit;
		}
			if((int)$_POST['check'] !== 1){
				echo messageJson('erro', 'Aceite os Termos e Condições de uso para continuar');exit;
			}
 
			$userName     = stringInputCleaner($_POST['userName']);
			$userEmail    = stringInputCleaner($_POST['userEmail']);
			$userPhone    = stringInputCleaner($_POST['userPhone']);
			$userPwd      = stringInputCleaner($_POST['password']);
				$userPwd  	= password_hash($userPwd, PASSWORD_DEFAULT);
			$userCode	  = uniqid(time().'.'.rand(), true);
			$userStatus   = 1;
			$userFoto 	  = 'sem-logo.png';
			$plano_id 	  = 1;

				$results = findItem($conectDB, 'usuario', ' id, email ', array("email"=>$userEmail) );
				if(!empty($results->id))
				{
					echo messageJson('erro', 'Já existe um cadastro com este endereço de e-mail');exit;
				}

		        $cadinsert = "INSERT into usuario (code, nome, email, celular, pwd, foto, plano_id, cadastro, ativo) VALUES (
		        	:code, :nome, :email, :celular, :pwd, :foto, :plano_id, :cadastro, :ativo
		        )";
			


	        try {
	            $cadresult = $conectDB->prepare($cadinsert);
	            $cadresult->bindParam(':code' , $userCode, PDO::PARAM_STR);
	            $cadresult->bindParam(':nome' , $userName, PDO::PARAM_STR);
	            $cadresult->bindParam(':email', $userEmail, PDO::PARAM_STR);
	            $cadresult->bindParam(':celular', $userPhone, PDO::PARAM_STR);
	            $cadresult->bindParam(':pwd' , 	$userPwd, PDO::PARAM_STR);
	            $cadresult->bindParam(':foto' , 	$userFoto, PDO::PARAM_STR);
	            $cadresult->bindParam(':plano_id' , $plano_id, PDO::PARAM_STR);
	            $cadresult->bindParam(':cadastro' , $dataCadastro, PDO::PARAM_STR);
	            $cadresult->bindParam(':ativo' , $userStatus, PDO::PARAM_STR);
	            $cadresult->execute();
	            $cadcontar = $cadresult->rowCount();
	            if($cadcontar > 0) {

	            	$_SESSION['userLogged'] = true;
	            	$_SESSION['userID']	 = $conectDB->lastInsertId();
 
	            	$_SESSION['userCode']	= $userCode;
	            	$_SESSION['userName']	= $userName;
	            	$_SESSION['userEmail']	= $userEmail;
		            $_SESSION['userFoto']	= $userFoto;
					$_SESSION['userCadastro']	= $dataCadastro;

	            	//enviaEmail($userEmail, $userName, "Seja bem vindo ".$userName, $configEmails['novoCadastro'], '', '');
					
					
					///cadastra site
						$corBase 	= '#E85B01';
						$tituloBase = 'Seja Bem Vindo(a)!';
						
						$cadSite = "INSERT into site (usuario_id, cor_base, home_header_titulo, cadastro ) VALUES (
							:usuario_id, :cor_base, :home_header_titulo, :cadastro
						)";
						$cadresult = $conectDB->prepare($cadSite);
						$cadresult->bindParam(':usuario_id' , 	$_SESSION['userID'], PDO::PARAM_STR);
						$cadresult->bindParam(':cor_base' , 	$corBase, PDO::PARAM_STR);
						$cadresult->bindParam(':home_header_titulo', $tituloBase, PDO::PARAM_STR);
						//$cadresult->bindParam(':home_header_imagem', $imagemBase, PDO::PARAM_STR);
						$cadresult->bindParam(':cadastro' , 	$dataCadastro, PDO::PARAM_STR);
						$cadresult->execute();
						
						$_SESSION['siteID']	=  $conectDB->lastInsertId();
					///cadastra site
					
					
	                echo messageJson('sucesso', 'Cadastro realizado com sucesso, por favor, aguarde...', 'redirectToUrl', 'dashboard' );

	            }
	        }
	        catch(PDOException $e) {
	            echo messageJson('erro', 'Houve algo de errado, tente novamente', '', '');
	        }

}