<?php
require 'app/bootstrap.php';
$conectDB = connectDB();
$conectDB->exec("set names utf8mb4");
 ?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <title><?=$configSistema['sistema'] ;?></title>
    <?php
        include 'estrutura/__css.php';
    ?>
    <style>
        @media screen and (max-width: 767px)
        {
            .containerLogin{padding-top: 100px}
        }
            @media screen and (min-width: 768px)
            {
                .containerLogin{padding-top: 200px}
            }
    </style>
</head>
<body>
	<div class="app">
	
		<div class="container-fluid">
            <div class="d-flex full-height p-v-20 flex-column justify-content-between">

                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-md-6 d-none d-md-block">
							<div class="d-none d-md-flex p-h-40 m-b-30">
								<img src="assets/logo.png" alt="" width="120px">
							</div>
                            <img class="img-fluid  m-t-30" src="assets/register.webp" alt="">
                        </div>
                        <div class="m-l-auto col-md-5 m-t-20">
                            <div class="card">
                                <div class="card-body">
                                    <h2 class="m-t-5">Cadastre-se</h2>
                                    <p class="">Informe seus dados abaixo</p>
                                    <form method="POST" action="app/register" id="frmRegUser">
                                        <div class="form-group">
                                            <label class="font-weight-semibold" for="userName">Seu Nome:</label>
                                            <input type="text" class="form-control" id="userName" name="userName" placeholder="" required required_m="Obrigatório">
                                        </div>
                                        <div class="form-group">
                                            <label class="font-weight-semibold" for="email">E-mail:</label>
                                            <input type="email" class="form-control" id="email" name="userEmail"  required required_m="Obrigatório">
                                        </div>
                                        <div class="form-group">
                                            <label class="font-weight-semibold" for="email">Telefone:</label>
                                            <input type="text" class="form-control telefone" id="phone" name="userPhone" placeholder="">
                                        </div>
                                        <div class="form-group">
                                            <label class="font-weight-semibold" for="password">Senha:</label>
                                            <input type="password" class="form-control" id="password" name="password"  required required_m="Obrigatório">
                                        </div>
                                        <div class="form-group">
                                            <label class="font-weight-semibold" for="confirmPassword">Confirmar sua senha:</label>
                                            <input type="password" class="form-control" id="confirmPassword" name="confirmPassword"  required required_m="Obrigatório">
                                        </div>
                                        <div class="form-group">
                                            <div class="d-flex align-items-center justify-content-between  ">
                                                <div class="checkbox">
                                                    <input id="checkbox" name="check" value="1" type="checkbox" required required_m="Obrigatório" >
                                                    <label for="checkbox"><span>Eu concordo com os <a href="https://txto.online/termo-de-uso-plataforma-txto/" target="_blank">termos e condições de uso</a></span></label>
                                                </div>
												<br>
                                               
                                            </div>
                                            <div class="d-flex align-items-center justify-content-between text-center"> 
												<button  class="btn  btn-primary m-r-5 submit m-t-20">
													<i class="anticon anticon-loading m-r-5"></i>
													<i class="anticon anticon-check m-r-5"></i>
													<span>Cadastrar</span>
												</button>
                                            </div>
											<hr>
											<span class="font-size-16 m-t-20">
                                               Já tem um cadastro? 
                                                <a class="" href="login"> Entrar</a>
                                            </span>
											  
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="d-none d-md-flex  p-h-40 justify-content-between">
                    <span class="">© <?=date("Y");?> </span>
                    <ul class="list-inline">
                        <li class="list-inline-item">
                            <a class="text-dark text-link" href="https://txto.online/termo-de-uso-plataforma-txto/" target="_blank">Termos e Condições de Uso</a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
		 
    </div>
	<?php include 'estrutura/__js.php';?>
 	<script>
		$(document).on('submit', '#frmRegUser', function()
		{
			if( $('#checkbox').is(':checked') )
			{}
			else
			{
				Notificacao('error', 'É preciso confirmar os termos e condições de uso', 'Obrigatório'); 
				$("#checkbox").focus();
				return false;
			}
		});
	</script>
</body>

</html>