<?php
require '../app/bootstrap.php';
$conectDB = connectDB();
$conectDB->exec("set names utf8mb4");
include '__admin_valida_login.php';
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <title><?=$configSistema['sistema'];?> - Configurações</title>
	<?php
		include 'estrutura/__css.php';
	?>
</head>
<body>
    <div class="app">
        <div class="layout">
			<?php
				include 'estrutura/topo.php';
				include '_menu.php';
			?>
			
			
			
			
			<div class="page-container">
                <div class="main-content">
                    <div class="page-header no-gutters has-tab">
                        <h2 class="font-weight-normal">Ajustes no Sistema</h2>
                        <ul class="nav nav-tabs">
                            <li class="nav-item">
                                <a class="nav-link active" data-toggle="tab" href="#tab-ajustes">Ajustes</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="tab" href="#tab-categorias">Planos</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" data-toggle="tab" href="#tab-politicas">Políticas de Privacidade </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="tab" href="#tab-termos">Termos </a>
                            </li>
                        </ul>
                    </div>

                    <div class="container-fluid">
                        <div class="tab-content m-t-15">
						
								<div class="tab-pane fade active show" id="tab-ajustes">
									<form method="post" action="" id="FrmAjustesConfigEscola" enctype="multipart/form-data">
											<h4 class="card-title">Ajustes</h4>
											<div class="row">
												<div class="col-md-12"> 
													<div class="card">
														<div class="card-body">
															<?php
																if ($_SERVER['REQUEST_METHOD'] === 'POST')
																{
																	if(isset($_POST['editaConfig'])){
																		$whatsapp =  stringInputCleaner($_POST['whatsapp']);
																		$telefone =  stringInputCleaner($_POST['telefone']); 
																		$email 	  =  stringInputCleaner($_POST['email']); 
																		
																		$cadinsert = "
																			UPDATE
																				configuracao
																			SET
																				whatsapp 	= :whatsapp,
																				telefone 	= :telefone,
																				email 		= :email
																			WHERE
																				id 	= 1
																		";
																			$cadresult = $conectDB->prepare($cadinsert);
																			$cadresult->bindParam(':whatsapp' , $whatsapp, PDO::PARAM_STR);
																			$cadresult->bindParam(':telefone' , $telefone, PDO::PARAM_STR);
																			$cadresult->bindParam(':email' , $email, PDO::PARAM_STR);
	 																		if ($cadresult->execute()) { 
																				echo mensagem('sucesso', 'Dados atualizados com sucesso, aguarde...'); 
																			}
																			else
																			{
																				echo mensagem('erro', 'Parece que houve algo de errado, por favor, tente novamente.');
																			}
																		
																		redirect('configuracoes.php');
																	}
																}
																$configuracoes = findItem($conectDB, 'configuracao', ' * ', array("id"=>'1') );

																$planoProfessores 	= findItem($conectDB, 'plano', ' * ', array("id"=>'1') );
																$planoEscolas 		= findItem($conectDB, 'plano', ' * ', array("id"=>'2') );
																 
															?>
													   
															<div class="row">
																<div class="col-lg-12">
																	<hr>
																	<h3>Dados de Contato</h3>
																	
																	<div class="row">
																		<div class="form-group col-md-4">
																			<label class="font-weight-semibold" for="userName">E-mail</label>
																			<input type="text" class="form-control" id="email" name="email" value="<?=$configuracoes->email;?>" id="email">
																		</div>  
																			<div class="form-group  col-md-4">
																				<label class="font-weight-semibold" >WhatsApp</label>
																				<input type="text" class="form-control" id="contato_fone" name="whatsapp" value="<?=$configuracoes->whatsapp;?>" id="whatsapp">
																			</div>
																			<div class="form-group  col-md-4">
																				<label class="font-weight-semibold" >Telefone</label>
																				<input type="text" class="form-control" id="contato_cidade" name="telefone" value="<?=$configuracoes->telefone;?>" id="telefone">
																			</div>
																	</div>
																</div>
															</div>
													 
																<div class="row">
																	<div class="col-sm-3 text-left">
																		<input type="hidden" value="editaConfig" name="editaConfig">
																		<button type="submit" class="btn  btn-primary m-r-5">
																				<i class="anticon anticon-check m-r-5"></i>
																			<span>Salvar</span>
																		</button>
																	</div>
																</div>
														</div>
													</div>
												</div>
											</div>
									</form>
								</div>
						 
						 
                            <div class="tab-pane fade" id="tab-categorias">
								<div class="row">
									<div class="col-md-12"> 
										<div class="card">
											<form method="post" action="" id="FrmAjustesConfigEscola" enctype="multipart/form-data">
												<div class="card-body">
													<?php
														if ($_SERVER['REQUEST_METHOD'] === 'POST')
														{
															if(isset($_POST['editaPlanos'])){
																//print_r($_POST);
																$pM =  str_replace(',','.',str_replace('.','', stringInputCleaner($_POST['pM']) ));
																$pT =  str_replace(',','.',str_replace('.','', stringInputCleaner($_POST['pT']) ));
																$pS =  str_replace(',','.',str_replace('.','', stringInputCleaner($_POST['pS']) ));
																$pA =  str_replace(',','.',str_replace('.','', stringInputCleaner($_POST['pA']) ));

																$cadinsert = "
																	UPDATE
																		plano
																	SET
																		mensal 	= :pM,
																		trimestral 	= :pT,
																		semestral 	= :pS,
																		anual 	= :pA
																	WHERE
																		id 	= 1
																";
																	$cadresult = $conectDB->prepare($cadinsert);
																	$cadresult->bindParam(':pM' , $pM, PDO::PARAM_STR);
																	$cadresult->bindParam(':pT' , $pT, PDO::PARAM_STR);
																	$cadresult->bindParam(':pS' , $pS, PDO::PARAM_STR);
																	$cadresult->bindParam(':pA' , $pA, PDO::PARAM_STR);
																	$cadresult->execute();


																$eM =  str_replace(',','.',str_replace('.','', stringInputCleaner($_POST['eM']) ));
																$eT =  str_replace(',','.',str_replace('.','', stringInputCleaner($_POST['eT']) ));
																$eS =  str_replace(',','.',str_replace('.','', stringInputCleaner($_POST['eS']) ));
																$eA =  str_replace(',','.',str_replace('.','', stringInputCleaner($_POST['eA']) ));

																$cadinsertA = "
																	UPDATE
																		plano
																	SET
																		mensal 		= :eM,
																		trimestral 	= :eT,
																		semestral 	= :eS,
																		anual 		= :eA
																	WHERE
																		id 	= 2
																";
																	$cadresultA = $conectDB->prepare($cadinsertA);
																	$cadresultA->bindParam(':eM' , $eM, PDO::PARAM_STR);
																	$cadresultA->bindParam(':eT' , $eT, PDO::PARAM_STR);
																	$cadresultA->bindParam(':eS' , $eS, PDO::PARAM_STR);
																	$cadresultA->bindParam(':eA' , $eA, PDO::PARAM_STR);
																	$cadresultA->execute();
																	
																	echo mensagem('sucesso', 'Dados atualizados com sucesso, aguarde...'); 
																	 
																
																	redirect('configuracoes.php');
															}
														}
															 
													?>
													 
													<h3>Planos para Professores</h3>
													<table class="table  table-bordered table-hover sample_lead" style="width: 100%">
														<tbody>
															 <tr>
															 	<td>
	 																<label class="font-weight-semibold" for="userName">Preço por Mês</label>
																	<input type="text" class="form-control moeda" id="pM" name="pM" value="<?=currency( $planoProfessores->mensal );?>">
	 														 	</td>
															 	<td>
	 																<label class="font-weight-semibold" for="userName">Trimestral</label>
																	<input type="text" class="form-control moeda" id="pT" name="pT" value="<?=currency( $planoProfessores->trimestral);?>">
	 														 	</td>
															 	<td>
	 																<label class="font-weight-semibold" for="userName">Semestral</label>
																	<input type="text" class="form-control moeda" id="pS" name="pS" value="<?=currency( $planoProfessores->semestral);?>">
	 														 	</td>
															 	<td>
	 																<label class="font-weight-semibold" for="userName">Anual</label>
																	<input type="text" class="form-control moeda" id="pA" name="pA" value="<?=currency( $planoProfessores->anual);?>">
	 														 	</td>
	 														</tr>
														</tbody>
													</table>

													<h3>Planos para Escola</h3>
													<table class="table  table-bordered table-hover sample_lead" style="width: 100%">
														<tbody>
															 <tr>
															 	<td>
	 																<label class="font-weight-semibold" for="userName">Preço por Mês</label>
																	<input type="text" class="form-control moeda" id="eM" name="eM" value="<?=currency( $planoEscolas->mensal );?>">
	 														 	</td>
															 	<td>
	 																<label class="font-weight-semibold" for="userName">Trimestral</label>
																	<input type="text" class="form-control moeda" id="eT" name="eT" value="<?=currency( $planoEscolas->trimestral);?>">
	 														 	</td>
															 	<td>
	 																<label class="font-weight-semibold" for="userName">Semestral</label>
																	<input type="text" class="form-control moeda" id="eS" name="eS" value="<?=currency( $planoEscolas->semestral);?>">
	 														 	</td>
															 	<td>
	 																<label class="font-weight-semibold" for="userName">Anual</label>
																	<input type="text" class="form-control moeda" id="eA" name="eA" value="<?=currency( $planoEscolas->anual);?>">
	 														 	</td>
	 														</tr>
														</tbody>
													</table>
														<div class="row">
															<div class="col-sm-3 text-left">
																<input type="hidden" value="editaConfigPoliticas" name="editaPlanos">
																<button type="submit" class="btn  btn-primary m-r-5">
																		<i class="anticon anticon-check m-r-5"></i>
																	<span>Salvar</span>
																</button>
															</div>
														</div>
												</div>
											</form>
										</div>
									</div>
								</div>
							</div>





								<div class="tab-pane fade" id="tab-politicas">
									<form method="post" action="" id="FrmAjustesConfigEscola" enctype="multipart/form-data">
											<h4 class="card-title">Ajustes</h4>
											<div class="row">
												<div class="col-md-12"> 
													<div class="card">
														<div class="card-body">
															<?php
																if ($_SERVER['REQUEST_METHOD'] === 'POST')
																{
																	if(isset($_POST['editaConfigPoliticas'])){

																		$politicas =  stringInputCleaner($_POST['politicas']);

																		$cadinsert = "
																			UPDATE
																				configuracao
																			SET
																				politicas 	= :politicas
																			WHERE
																				id 	= 1
																		";
																			$cadresult = $conectDB->prepare($cadinsert);
																			$cadresult->bindParam(':politicas' , $politicas, PDO::PARAM_STR);
	 																		if ($cadresult->execute()) { 
																				echo mensagem('sucesso', 'Dados atualizados com sucesso, aguarde...'); 
																			}
																			else
																			{
																				echo mensagem('erro', 'Parece que houve algo de errado, por favor, tente novamente.');
																			}
																		
																			redirect('configuracoes.php');
																	}
																}
 																 
															?>
													   
															<div class="row">
																<div class="col-lg-12">
																	<h3>Condições de Uso</h3>
																	
																	<div class="row">
																		<div class="form-group col-md-12">
 																			<textarea rows="15" class="form-control" name="politicas" value="" id="politicas"><?=$configuracoes->politicas;?></textarea>
																		</div>  
																	</div>
																</div>
															</div>
													 
																<div class="row">
																	<div class="col-sm-3 text-left">
																		<input type="hidden" value="editaConfigPoliticas" name="editaConfigPoliticas">
																		<button type="submit" class="btn  btn-primary m-r-5">
																				<i class="anticon anticon-check m-r-5"></i>
																			<span>Salvar</span>
																		</button>
																	</div>
																</div>
														</div>
													</div>
												</div>
											</div>
									</form>
								</div>












								<div class="tab-pane fade " id="tab-termos">
									<form method="post" action="" id="FrmAjustesConfigEscola" enctype="multipart/form-data">
											<h4 class="card-title">Ajustes</h4>
											<div class="row">
												<div class="col-md-12"> 
													<div class="card">
														<div class="card-body">
															<?php
																if ($_SERVER['REQUEST_METHOD'] === 'POST')
																{
																	if(isset($_POST['editaConfigTermos'])){

																		$termos =  stringInputCleaner($_POST['termos']);

																		$cadinsert = "
																			UPDATE
																				configuracao
																			SET
																				termos 	= :termos
																			WHERE
																				id 	= 1
																		";
																			$cadresult = $conectDB->prepare($cadinsert);
																			$cadresult->bindParam(':termos' , $termos, PDO::PARAM_STR);
	 																		if ($cadresult->execute()) { 
																				echo mensagem('sucesso', 'Dados atualizados com sucesso, aguarde...'); 
																			}
																			else
																			{
																				echo mensagem('erro', 'Parece que houve algo de errado, por favor, tente novamente.');
																			}
																		
																			redirect('configuracoes.php');
																	}
																}
 																 
															?>
													   
															<div class="row">
																<div class="col-lg-12">
																	<h3>Termos de Uso</h3>
																	
																	<div class="row">
																		<div class="form-group col-md-12">
 																			<textarea rows="15" class="form-control" name="termos" value="" id="termos"><?=$configuracoes->termos;?></textarea>
																		</div>  
																	</div>
																</div>
															</div>
													 
																<div class="row">
																	<div class="col-sm-3 text-left">
																		<input type="hidden" value="editaConfigTermos" name="editaConfigTermos">
																		<button type="submit" class="btn  btn-primary m-r-5">
																				<i class="anticon anticon-check m-r-5"></i>
																			<span>Salvar</span>
																		</button>
																	</div>
																</div>
														</div>
													</div>
												</div>
											</div>
									</form>
								</div>
















							
							
							 
					 <!-- Modal Nova Classe -->
					<div class="modal fade" id="modalRemoveEmpresa">
						<div class="modal-dialog modal-dialog-centered">
							<div class="modal-content">
								<div class="modal-header  text-center">
									<h5 class="modal-title" id="">Remoção de registro</h5>
									<button type="button" class="close" data-dismiss="modal">
										<i class="anticon anticon-close"></i>
									</button>
								</div>
								<div class="modal-body">
									<form method="post" id="modalClasseFormPost" action="php/sistema.php">
										<h2>Deseja remover este registro</h2>
										 
										<div class="form-group row">
											<div class="col-sm-6">
												 
												<a href="#" id="modalRemoveEmpresaLink" class="btn  btn-primary m-r-5 ">
													<i class="anticon anticon-loading m-r-5"></i>
													<i class="anticon anticon-check m-r-5"></i>
													<span>Remover</span>
												</a>
											</div>
				 
										</div>
									</form>
								</div> 
							</div>
						</div>
					</div>
								
								
								
                        </div>
					</div>
                </div>
				
				<?php include 'estrutura/copy.php';?>
            </div> 
			<?php include 'estrutura/_sidebar.php';?>
    </div>
</div>
	<style>
 
	</style>
    

	<?php include 'estrutura/rodape.php';?>


	<script src="https://cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js" type="text/javascript"></script>
	<script src="https://cdn.datatables.net/1.10.25/js/dataTables.bootstrap4.min.js" type="text/javascript"></script>
	
	<script src="https://cdn.datatables.net/fixedheader/3.1.9/js/dataTables.fixedHeader.min.js" type="text/javascript"></script>
	<script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js" type="text/javascript"></script>
	<script src="https://cdn.datatables.net/responsive/2.2.9/js/responsive.bootstrap.min.js" type="text/javascript"></script>
	
	<script src="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" type="text/javascript"></script>
	<link href="https://cdn.datatables.net/fixedheader/3.1.9/css/fixedHeader.bootstrap.min.css" rel="stylesheet" type="text/css" />
	<link href="https://cdn.datatables.net/1.10.25/css/dataTables.bootstrap4.min.css" rel="stylesheet" type="text/css" />
	
	
	<script src="https://cdn.tiny.cloud/1/5b9a9u8uau2pgvrb4709adrywcky5q5g758p0m9oephbzh7j/tinymce/4/tinymce.min.js" referrerpolicy="origin"></script>
 	<script>
	$(document).ready(function() {
		var table = $('.sample_lead').DataTable( {
            "language": {
                "aria": {
                    "sortAscending": ": activate to sort column ascending",
                    "sortDescending": ": activate to sort column descending"
                },
                "emptyTable": "Nenhum registro encontrado",
                "info": "Mostrando _START_ de _END_ de _TOTAL_ registros",
                "infoEmpty": "Sem registros",
                "infoFiltered": "(filtered1 from _MAX_ total registros)",
                "lengthMenu": "_MENU_ registros",
                "search": "Buscar:",
                "zeroRecords": "Nenhum registro"
            },
            "language": {
               url: '//cdn.datatables.net/plug-ins/3cfcc339e89/i18n/Portuguese.json'
            },
            responsive: true,

            "order": [
                [0, 'asc']
            ],
            
            "lengthMenu": [
                [5, 30, 50, 100, -1],
                [5, 30, 50, 100, "Todos"] // change per page values here
            ],
            // set the initial value
            "pageLength": 50,
		});
 
	} );
 
	</script>
 	<script>
		$(".removeItemEmpresa").on("click", function()
		{
			$("#modalRemoveEmpresa").modal("show");
			$("#modalRemoveEmpresaLink").attr("href", $(this).attr("link") );
		});
	</script>
</body>

</html>