<?php
require '../app/bootstrap.php';
$conectDB = connectDB();
$conectDB->exec("set names utf8mb4");
include '__admin_valida_login.php';
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <title><?=$configSistema['sistema'];?> - Exibindo Escolas</title>
	<?php
		include 'estrutura/__css.php';
	?>
</head>
<body>
    <div class="app ">
        <div class="layout  ">
		<?php
			include 'estrutura/topo.php';
			include '_menu.php';

			if(!isset($_GET['escola']))
			{
				echo redirect('escolas');
			}
			else
			{
				$escola    = stringInputCleaner($_GET['escola']);

 				$dadosEscola = findItem($conectDB, 'escola', ' * ', array("code"=>$escola) );
				if(empty($dadosEscola->id))
				{
					echo redirect('escolas');
				}  
			}

			$sql = "
				select
					COUNT(vaga.id) as totalVagas,
					(SELECT COUNT(vaga.id) FROM vaga WHERE vaga.escola_id = {$dadosEscola->id} and ativo = 0 and motivo_desativa = 'Contratei pelo Localiza') as totalContratados,
					(SELECT COUNT(professor.id) FROM professor, escola WHERE escola.id = {$dadosEscola->id} and professor.cidade_id = escola.cidade_id) as totalProfessores
				from
					vaga
				WHERE
					vaga.escola_id = {$dadosEscola->id}
			";
			 
			$totalizadores  = query($conectDB, '', $sql);
			$totalVagas = $totalizadores[0]->totalVagas;
			$totalContratados = $totalizadores[0]->totalContratados; 

			$totalProfessores = $totalizadores[0]->totalProfessores; 
			if( (empty($dadosEscola->cidade_id)) || ($dadosEscola->cidade_id == 0) ){
				$totalProfessores = 0; 
			}

			$titulo = 'Escola: '.$dadosEscola->nome; 
		?>
       	 	<div class="page-container">
            	<div class="main-content">
                 
               		<div class="card  ">
                    	<div class="card-body"> 
                        <h4 class=" "><?=$titulo;?></h4>
	                        <div class="m-t-25">
 								<div class="row"> 
									<div class="col-md-12 col-lg-12 m-b-20">
										<?php
											echo 'Cadastrado em: '.date("d/m/Y H:i", strtotime( $dadosEscola->cadastro ) ).'<br>';

											if($dadosEscola->ativo == '3')
											{
												echo 
												'
													<span class="badge badge-danger">Desativado</span>
												';
 											}
											elseif($dadosEscola->ativo == '2')
											{
												echo
												'
													<span class="badge badge-warning">Solicitado desativação</span>
												';
											}
											else
											{
												echo
												'
													<span class="badge badge-info">Ativo</span>
												';
											}



										?>
									</div>
									<div class="col-md-4 col-lg-4">
										<div class="card">
											<div class="card-body">
												<div class="d-flex justify-content-between align-items-center">
													<div>
														<p class="m-b-0">Professores Contratados</p>
														<h2 class="m-b-0">
															<span>
																<?=$totalContratados;?>
															</span>
														</h2>
													</div> 
												</div>
											</div>
										</div>
									</div>
										<div class="col-md-4 col-lg-4">
											<div class="card">
												<div class="card-body">
													<div class="d-flex justify-content-between align-items-center">
														<div>
															<p class="m-b-0">Total de Vagas</p>
															<h2 class="m-b-0">
															<span>
																<?=$totalVagas;?>
															</span>
															</h2>
														</div> 
													</div>
												</div>
											</div>
										</div>
										<div class="col-md-4 col-lg-4">
											<div class="card">
												<div class="card-body">
													<div class="d-flex justify-content-between align-items-center">
														<div>
															<p class="m-b-0">Professoras mesma cidade</p>
															<h2 class="m-b-0">
															<span>
																<?=$totalProfessores;?>
															</span>
															</h2>
														</div> 
													</div>
												</div>
											</div>
										</div>
										 
									<div class="col-md-12 col-lg-12">

										<div class="table-responsive">
											<table class="table table-hover colaboradores tabelaColaboradores" style="width: 100% !important" >
												<thead>
													<tr>
														<th scope="col" class="pl-0 border-0 font-size-4 font-weight-normal">Vaga</th>
														<th scope="col" class="pl-4 border-0 font-size-4 font-weight-normal">Ensino</th>
														<th scope="col" class="pl-4 border-0 font-size-4 font-weight-normal">Horário</th>
														<th scope="col" class="pl-4 border-0 font-size-4 font-weight-normal">Cadastro</th>
														<th scope="col" class="pl-4 border-0 font-size-4 font-weight-normal">Status</th>
													</tr>
												</thead>
												<tbody>
													<?php
														$sql = "
															select
																disciplina.nome AS disciplinaNome,
																vaga.tipo_vaga AS vagaTipo,
																vaga.horario AS vagaHorario,
																tipo_ensino.nome AS tipoEnsino,
																vaga.cadastro,
																vaga.code as vagaCode,
																vaga.ativo as vagaStatus
															from
																vaga,
																disciplina,
																tipo_ensino
															WHERE
																vaga.disciplina_id = disciplina.id and
																vaga.tipo_ensino_id = tipo_ensino.id and
																vaga.escola_id = '{$dadosEscola->id}'
															order by vaga.id desc
														";
														$totalResults = 0;
														$searchTeachers  = query($conectDB, 'assoc', $sql);
														if($searchTeachers !== 'error'){
								 							
								 							$totalResults = count($searchTeachers );
															if( $totalResults == 0){
																echo '	
																	<div class="col-12 col-lg-12 text-center">
																		<h4>Nenhuma vaga</h4>
																		<lottie-player src="https://assets1.lottiefiles.com/packages/lf20_uqfbsoei.json"  background="transparent"  speed="1"  style="width: 100%; height: 300px;"  loop  autoplay></lottie-player>
																	</div>
																';
															}
															else
															{
																foreach($searchTeachers as $registro)
																{
																	$titulo = 'Professor de '.$registro['disciplinaNome'];
																	if( (int)$registro['vagaTipo'] == 2){
																		$titulo = 'Estagiário de '.$registro['disciplinaNome'];
																	}

																	if( (int)$registro['vagaHorario'] == 1){ $horario = 'Manhã';}
																	if( (int)$registro['vagaHorario'] == 2){ $horario = 'Tarde';}
																	if( (int)$registro['vagaHorario'] == 3){ $horario = 'Noite';}

																	$mostraBotoes = 'block';
																	$status = '<span class="badge badge-info">Disponível</span>';
																	if($registro['vagaStatus'] == '0'){
																		$status = '<span class="badge badge-warning">Desativado</span>';
																		$mostraBotoes = 'none';
																	}
																	echo 
																	'
																	<tr class="">
																		<th scope="row" class="">
																			'.$titulo.'
																		</th>
																		<td class="">
																		  '.$registro['tipoEnsino'].'
																		</td> 
																		<td class="">
																		  '.$horario.'
																		</td> 
																		<td class="">
																		 '.date("d/m/Y H:i", strtotime($registro['cadastro'])).'
																		</td> 
																		<td class="">
																		  '.$status.'
																		</td> 
																	</tr>
																	';
																}
															}
														}
												?>
												</tbody>
											</table>
										</div>
									</div>
									
									
									
								</div>
	 						</div>
						</div>
               	 	</div>
				</div>
				<?php include 'estrutura/copy.php';?>	
            </div>
         </div>
    </div>
	<?php include 'estrutura/rodape.php';?>
	<?php include 'estrutura/_modal_admin.php';?>
