<?php
require 'app/bootstrap.php';
$conectDB = connectDB();
$conectDB->exec("set names utf8mb4");
include '__valida_login.php';
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <title><?=$configSistema['sistema'];?> - Histórico de Tarefas</title>
	<?php
		include 'estrutura/__css.php';
	?>
</head>
<body>
    <div class="app ">
        <div class="layout  ">
			<?php
				include 'estrutura/topo.php';
				include '_menu.php'; 
			?>
            <div class="page-container">
                <div class="main-content">
                     
                   <div class="card  ">
                        <div class="card-body"> 
                            <h4 class=" ">Histórico de Tarefas</h4>
                            <div class="">
								<div class=" ">
									  
									<table class="table  table-bordered table-hover " id="sample_lead" style="width: 100%">
										<thead>
											<tr>
  												<th class="all"> Tarefa</th>
												<th class="all"> Tipo</th>
												<th class="all"> Adicionado</th>
												<th class="all"> Status</th>
												<th class="all"> Executada em </th>
											</tr>
										</thead>
										<tbody>
											<?php
												$searchItem  = query($conectDB, '', "
													select
														*,
														usuario_entrada.status as statusPagamento,
														anuncio_tipo.nome as anuncioTipo,
														usuario_entrada.cadastro as entradaData
													from
														usuario_anuncio,
														usuario_entrada,
														anuncio

														INNER JOIN
															anuncio_tipo
														ON
															anuncio.anuncio_tipo_id = anuncio_tipo.id
													WHERE
														usuario_anuncio.usuario_id = '{$_SESSION['userID']}' and
														usuario_anuncio.anuncio_id = anuncio.id and
														usuario_entrada.anuncio_id = usuario_anuncio.anuncio_id and
														usuario_entrada.usuario_anuncio_id = usuario_anuncio.id and
														usuario_anuncio.status = 1
												");
												//print_r($searchItem);
												if( count($searchItem) <= 0 ){
													echo '
														<div class="col-md-12 text-center">
															<h4>nenhum registro encontrada</h4>
															<lottie-player src="https://assets7.lottiefiles.com/packages/lf20_zadfo6lc.json"  background="transparent"  speed="1"  style="width: 100%; height: 300px;"  loop  autoplay></lottie-player>
														</div>
													';
												}
												else
												{
													foreach($searchItem as $usuario)
													{
														if($usuario->statusPagamento == 1)
														{
															$status = 
															'
																<span class="badge badge-sucess">Pago</span>
															';
														}
														elseif($usuario->statusPagamento == 2)
														{
															$status = 
															'
																<span class="badge badge-warning">Pendente Recebimento</span>
															';
														}
															echo 
															'
																<tr >
		  															<td >'.$usuario->titulo.'</td>
																	<td >'.$usuario->anuncioTipo.'</td>
																	<td >R$ '.currency($usuario->ganho).'</td>
		 															<td >'.$status.'</td>
																	<td >'.date("d/m/Y H:i", strtotime($usuario->entradaData)).'</td>
																	
																</tr>
															';
												}
											}
											?>
										</tbody>
									</table>
								</div>
							</div>
						</div>
					</div>
                </div>
				
				<?php include 'estrutura/copy.php';?>	
            </div>
         </div>
    </div>
	<?php include 'estrutura/rodape.php';?>
	<?php include 'estrutura/_modal_admin.php';?>
	



	 <!-- Modal Nova Classe -->
	<div class="modal fade" id="modalRemoveEmpresa">
		<div class="modal-dialog modal-dialog-centered">
			<div class="modal-content">
				<div class="modal-header  text-center">
					<h5 class="modal-title" id="">Remoção de registro</h5>
					<button type="button" class="close" data-dismiss="modal">
						<i class="anticon anticon-close"></i>
					</button>
				</div>
				<div class="modal-body">
					<form method="post" id="modalClasseFormPost" action="php/sistema.php">
						<h2>Deseja remover este registro</h2>
						O registro da professor e todas as suas informações serão desativadas no sistema
						<div class="form-group row">
							<div class="col-sm-6">
								 
								<a href="#" id="modalRemoveEmpresaLink" class="btn  btn-primary m-r-5 ">
									<i class="anticon anticon-loading m-r-5"></i>
									<i class="anticon anticon-check m-r-5"></i>
									<span>Remover</span>
								</a>
							</div>
 
						</div>
					</form>
				</div> 
			</div>
		</div>
	</div>




	<script src="https://cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js" type="text/javascript"></script>
	<script src="https://cdn.datatables.net/1.10.25/js/dataTables.bootstrap4.min.js" type="text/javascript"></script>
	
	<script src="https://cdn.datatables.net/fixedheader/3.1.9/js/dataTables.fixedHeader.min.js" type="text/javascript"></script>
	<script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js" type="text/javascript"></script>
	<script src="https://cdn.datatables.net/responsive/2.2.9/js/responsive.bootstrap.min.js" type="text/javascript"></script>
	
	<script src="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" type="text/javascript"></script>
	<link href="https://cdn.datatables.net/fixedheader/3.1.9/css/fixedHeader.bootstrap.min.css" rel="stylesheet" type="text/css" />
	<link href="https://cdn.datatables.net/1.10.25/css/dataTables.bootstrap4.min.css" rel="stylesheet" type="text/css" />

 

 	<script>
	$(document).ready(function() {
		var table = $('#sample_lead').DataTable( {
            dom: 'Bfrtip',
            //buttons: { buttons: [ { extend: 'copy', className: 'btn btn-primary btn-tone'}, { extend: 'csv', className: 'btn btn-primary btn-tone' } ]},
            "language": {
                "aria": {
                    "sortAscending": ": activate to sort column ascending",
                    "sortDescending": ": activate to sort column descending"
                },
                "emptyTable": "Nenhum registro encontrado",
                "info": "Mostrando _START_ de _END_ de _TOTAL_ registros",
                "infoEmpty": "Sem registros",
                "infoFiltered": "(filtered1 from _MAX_ total registros)",
                "lengthMenu": "_MENU_ registros",
                "search": "Buscar:",
                "zeroRecords": "Nenhum registro"
            },
            "language": {
               url: '//cdn.datatables.net/plug-ins/3cfcc339e89/i18n/Portuguese.json'
            },
            responsive: true,

            "order": [
                [5, 'desc']
            ],
            
            "lengthMenu": [
                [5, 30, 50, 100, -1],
                [5, 30, 50, 100, "Todos"] // change per page values here
            ],
            // set the initial value
            "pageLength": 50,
 

 
		});
	  
	} );
 
	</script>
	
	<script>
		$(".removeItemEmpresa").on("click", function()
		{
			$("#modalRemoveEmpresa").modal("show");
			$("#modalRemoveEmpresaLink").attr("href", $(this).attr("link") );
		});
	</script>
</body>

</html>

