<?php
require 'app/bootstrap.php';
$conectDB = connectDB();
$conectDB->exec("set names utf8mb4");
include '__valida_login.php';
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <title><?=$configSistema['sistema'];?> - Imóveis</title>
	<?php
		include 'estrutura/__css.php';
	?>
</head>
<body>
    <div class="app ">
        <div class="layout  ">
			<?php
				include 'estrutura/topo.php';
				include '_menu.php'; 
			?>
            <div class="page-container">
                <div class="main-content">
                     
                   <div class="card  ">
                        <div class="card-body"> 
							 
							<div class="row">
								<div class="col-xs-12 col-lg-2">
									<h1> Meus Imóveis</h1>
 								</div> 
							</div>
									
							<a href="imoveis/cadastro" class="btn btn-primary m-r-5 m-b-20 " ><i class="fa fa-money"></i> Cadastrar Imóvel</a>
							<a href="imoveis/importar" class="btn btn-success m-r-5 m-b-20 " ><i class="fa fa-retweet"></i> Importar Imóveis</a>

                            <div class="">
								<div class=" ">
									  

									<?php
										$searchItem  = query($conectDB, '', "
											select
												*
											from
												imovel
											WHERE
												usuario_id = '{$_SESSION['userID']}'
										");

										//print_r($searchItem);
										if( count($searchItem) <= 0 ){
											echo '
												<div class="col-md-12 text-center">
													<h4>nenhum imóvel encontrado</h4>
													<lottie-player src="https://assets6.lottiefiles.com/packages/lf20_dmw3t0vg.json"  background="transparent"  speed="1"  style="width: 100%; height: 300px;"  loop  autoplay></lottie-player>
												</div>
											';
										}
										else
										{
											echo 
											'
											<table class="table  table-bordered table-hover " id="sample_lead" style="width: 100%">
												<thead>
													<tr>
		   												<th class="all"> Título</th>
														<th class="all"> Tipo</th>
														<th class="all"> Valor</th>
														<th class="all"> Rua</th>
														<th class="all"> Destaque</th>
														<th class="all"> Cadastrado </th>
														<th class="all">  </th>
													</tr>
												</thead>
												<tbody>
											';
												foreach($searchItem as $value)
												{
													$destaque = '<form method="POST" action="app/imovel/favorito" id="frmDestaque_'.$value->id.'"><input type="hidden" value="'.$value->id.'" name="imovel"><button type="button" class="destaqueAdiciona submit" id="mudaDestaque_'.$value->id.'"><i class="far fa-heart"></i></button></form>';
													if( $value->destaque_home == 1){
														$destaque = '<form method="POST" action="app/imovel/favorito" id="frmDestaque_'.$value->id.'"><input type="hidden" value="'.$value->id.'" name="imovel"><button type="button" class="destaqueAdiciona submit" id="mudaDestaque_'.$value->id.'"><i class="fas fa-heart"></i></button></form>';
													}
													echo 
													'
														<tr >
																<td >'.$value->titulo.'</td>
																<td >'.$value->categoria.'</td>
																<td >R$ '.currency($value->valor).'</td>
																<td >'.$value->rua.'</td>
																<td class="text-left">'.$destaque.'</td>
																<td >'.date("d/m/Y H:i", strtotime($value->data_criacao)).'</td>
																<td class="text-center">
																	<a href="imoveis/detalhes/'.$value->codigo.'" class="btn btn-icon btn-info btn-xs btn-rounded btn-tone" style="line-height: 40px;">
																	    <i class="fa fa-eye"></i>
																	</a>
																	<a href="imoveis/edita/'.$value->codigo.'" class="btn btn-icon btn-primary btn-xs btn-rounded btn-tone" style="line-height: 40px;">
																	    <i class="fa fa-pen"></i>
																	</a>
																	<button class="btn btn-icon btn-danger btn-xs btn-rounded btn-tone">
																	    <i class="fa fa-times"></i>
																	</button>
																</td>
														</tr>
													';
												}
											echo 
											'
												</tbody>
											</table>
											';
										}
									?>

								</div>
							</div>
						</div>
					</div>
                </div>
				
				<?php include 'estrutura/copy.php';?>	
            </div>
         </div>
    </div>
	<?php include 'estrutura/rodape.php';?>
	<?php include 'estrutura/_modal_admin.php';?>
	



	 <!-- Modal Nova Classe -->
	<div class="modal fade" id="modalRemoveEmpresa">
		<div class="modal-dialog modal-dialog-centered">
			<div class="modal-content">
				<div class="modal-header  text-center">
					<h5 class="modal-title" id="">Remoção de registro</h5>
					<button type="button" class="close" data-dismiss="modal">
						<i class="anticon anticon-close"></i>
					</button>
				</div>
				<div class="modal-body">
					<form method="post" id="modalClasseFormPost" action="php/sistema.php">
						<h2>Deseja remover este registro</h2>
						O registro da professor e todas as suas informações serão desativadas no sistema
						<div class="form-group row">
							<div class="col-sm-6">
								 
								<a href="#" id="modalRemoveEmpresaLink" class="btn  btn-primary m-r-5 ">
									<i class="anticon anticon-loading m-r-5"></i>
									<i class="anticon anticon-check m-r-5"></i>
									<span>Remover</span>
								</a>
							</div>
 
						</div>
					</form>
				</div> 
			</div>
		</div>
	</div>




	<script src="https://cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js" type="text/javascript"></script>
	<script src="https://cdn.datatables.net/1.10.25/js/dataTables.bootstrap4.min.js" type="text/javascript"></script>
	
	<script src="https://cdn.datatables.net/fixedheader/3.1.9/js/dataTables.fixedHeader.min.js" type="text/javascript"></script>
	<script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js" type="text/javascript"></script>
	<script src="https://cdn.datatables.net/responsive/2.2.9/js/responsive.bootstrap.min.js" type="text/javascript"></script>
	
	<script src="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" type="text/javascript"></script>
	<link href="https://cdn.datatables.net/fixedheader/3.1.9/css/fixedHeader.bootstrap.min.css" rel="stylesheet" type="text/css" />
	<link href="https://cdn.datatables.net/1.10.25/css/dataTables.bootstrap4.min.css" rel="stylesheet" type="text/css" />

 

 	<script>
	$(document).ready(function() {
		var table = $('#sample_lead').DataTable( {
            dom: 'Bfrtip',
            //buttons: { buttons: [ { extend: 'copy', className: 'btn btn-primary btn-tone'}, { extend: 'csv', className: 'btn btn-primary btn-tone' } ]},
            "language": {
                "aria": {
                    "sortAscending": ": activate to sort column ascending",
                    "sortDescending": ": activate to sort column descending"
                },
                "emptyTable": "Nenhum registro encontrado",
                "info": "Mostrando _START_ de _END_ de _TOTAL_ registros",
                "infoEmpty": "Sem registros",
                "infoFiltered": "(filtered1 from _MAX_ total registros)",
                "lengthMenu": "_MENU_ registros",
                "search": "Buscar:",
                "zeroRecords": "Nenhum registro"
            },
            "language": {
               url: '//cdn.datatables.net/plug-ins/3cfcc339e89/i18n/Portuguese.json'
            },
            responsive: true,

            "order": [
                [4, 'desc']
            ],
            
            "lengthMenu": [
                [5, 30, 50, 100, -1],
                [5, 30, 50, 100, "Todos"] // change per page values here
            ],
            // set the initial value
            "pageLength": 50,
 

 
		});
	  
	} );
 
	</script>
	
	<script>
		$(".removeItemEmpresa").on("click", function()
		{
			$("#modalRemoveEmpresa").modal("show");
			$("#modalRemoveEmpresaLink").attr("href", $(this).attr("link") );
		});
	</script>
</body>

</html>

