<?php
require 'app/bootstrap.php';
$conectDB = connectDB();
$conectDB->exec("set names utf8mb4");
include '__valida_login.php';
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <title><?=$configSistema['sistema'];?> - Cadastro de Imóveis</title>
	<?php
		include 'estrutura/__css.php';
	?>
</head>
<body>
    <div class="app  ">
        <div class="layout ">
			<?php
				include 'estrutura/topo.php';
				include '_menu.php';
			?>
            <div class="page-container">
                <div class="main-content">
                   <div class="card  ">
                        <div class="card-body"> 
                            <h4 class=" ">Cadastro de Imóveis</h4>
                            <div class="row">
								<div class="col-lg-12 m-t-15">
										 
		<form method="POST" action="app/imovel/cadastro" enctype="multipart/form-data">
			<strong>Informações básicas</strong>
			<hr> 
			<div class="mb-3">
				<div class="row">
					<div class="col-lg-8 mb-3">
						<label for="titulo">Título do imóvel</label>
						<input type="text" class="form-control" id="titulo" placeholder="Digite o título" name="titulo" required="">
					</div>
					<div class="col-lg-4 mb-3">
						<label for="cadastraGerenciador">Cadastrar este Imóvel no Gerenciador?</label>
						<select class="form-control" id="cadastraGerenciador" name="cadastraGerenciador" required="">
							<option value="1">Sim</option>
							<option value="2">Não</option>
						</select>
					</div>
				</div>
			</div>
			<div class="mb-3">
				<div class="row">
					<div class="col-lg mb-lg-0 mb-3">
						<label for="situacao">Para vender ou para alugar?</label>
						<select class="form-control" id="situacao" name="situacao" required="">
							<option disabled="" selected="">Selecione se é aluguel ou venda</option>
							<option value="1">Aluguel</option>
							<option value="2">Venda</option>
						</select>
					</div>
					<div class="col-lg">
						<label for="categoria">Qual a categoria?</label>
				        <select class="form-control" id="categoria" name="categoria" required="">
							<option disabled="" selected="">Selecione a categoria</option>
							<option value="1">Apartamento</option>
							<option value="2">Área Rural</option>
							<option value="3">Barracão</option>
							<option value="4">Casa</option>
							<option value="5">Chácara</option>
							<option value="6">Cobertura</option>
							<option value="7">Comércio</option>
							<option value="8">Fazenda</option>
							<option value="9">Prédio</option>
							<option value="10">Sala Comercial</option>
							<option value="11">Sítio</option>
							<option value="12">Sobrado</option>
							<option value="13">Terreno</option>
						</select>
					</div>
				</div>
			</div>
			<div class="mb-3">
				<div class="row">
					<div class="col-lg mb-lg-0 mb-3">
						<label for="valor">Valor</label>
						<input type="text" class="form-control moeda" id="valor" placeholder="Digite o valor" name="valor">
					</div>
					<div class="col-lg mb-lg-0 mb-3">
						<label for="indice_de_reajuste_ao_consumidor">Indíce de reajuste ao consumidor</label>
						<select class="form-control" id="indice_de_reajuste_ao_consumidor" name="indice_de_reajuste_ao_consumidor" required="">
							<option disabled="" selected="">Selecione uma opção</option>
							<option value="1">IGPM</option>
							<option value="2">INPC</option>
						</select>
					</div>
					<div class="col-lg">
						<label for="area_total">Área total</label>
						<input type="number" class="form-control" id="area_total" placeholder="Digite a área total" name="area_total">
					</div>
				</div>
			</div>
			<div class="mb-3">
				<div class="row">
					<div class="col-lg mb-lg-0 mb-3">
						<label for="indice_cadastral">Índice Cadastral</label>
						<select class="form-control" id="indice_cadastral" name="indice_cadastral" required="">
							<option disabled="" selected="">Selecione uma opção</option>
							<option value="1">Pré-lançamento</option>
							<option value="2">Lançamento</option>
							<option value="3">Pronto/revenda</option>
						</select>
					</div>
					<div class="col-lg mb-lg-0 mb-3">
						<label for="construtora">Construtora</label>
						<input type="text" class="form-control" id="construtora" placeholder="Digite a construtora" name="construtora">
					</div>
					<div class="col-lg">
						<label for="idade">Idade</label>
						<input type="text" class="form-control" id="idade" placeholder="Digite a idade" name="idade">
					</div>
				</div>
			</div>
			<div class="mb-3">
				<div class="row">
					<div class="col-lg mb-lg-0 mb-3">
						<label for="posicao">Posição</label>
						<select class="form-control" id="posicao" name="posicao" required="">
							<option disabled="" selected="">Selecione uma opção</option>
							<option value="1">Frente</option>
							<option value="2">Fundos</option>
							<option value="3">Meio</option>
							<option value="4">Lateral</option>
						</select>
					</div>
					<div class="col-lg mb-lg-0 mb-3">
						<label for="topografia">Topografia</label>
						<select class="form-control" id="topografia" name="topografia" required="">
							<option disabled="" selected="">Selecione uma opção</option>
							<option value="1">Aclive</option>
							<option value="2">Declive</option>
							<option value="3">Plano</option>
						</select>
					</div>
					<div class="col-lg">
						<label for="taxa_do_condominio">Taxa do Condomínio</label>
						<input type="text" class="form-control money" id="taxa_do_condominio" placeholder="Digite a taxa do condomínio" name="taxa_do_condominio">
					</div>
				</div>
			</div>
			<div class="mb-3">
				<div class="row">
					<div class="col-lg mb-lg-0 mb-3">
						<label for="iptu">IPTU</label>
						<input type="number" class="form-control" id="iptu" placeholder="Digite o IPTU" name="iptu">
					</div>
					<div class="col-lg mb-lg-0 mb-3">
						<label for="permuta">Permuta</label>
						<select class="form-control" id="permuta" name="permuta" required="">
							<option disabled="" selected="">Selecione uma opção</option>
							<option value="1">Sim</option>
							<option value="2">Não</option>
						</select>
					</div>
					<div class="col-lg">
						<label for="imovel_ocupado">Imóvel ocupado?</label>
						<select class="form-control" id="imovel_ocupado" name="imovel_ocupado" required="">
							<option disabled="" selected="">Selecione uma opção</option>
							<option value="1">Em construção</option>
							<option value="2">Inquilino</option>
							<option value="3">Proprietário reside</option>
							<option value="4">Vazio / Lançamento / Planta</option>
						</select>
					</div>
				</div>
			</div>
			<div class="mb-3">
				<label for="descricao_do_imovel">Texto complementar - Descrição do imóvel</label>
				<textarea class="form-control" id="descricao_do_imovel" placeholder="Digite a descrição do imóvel" name="descricao_do_imovel" rows="5"></textarea>
			</div>
			<hr>
			<strong>Informações internas</strong>
			<hr>
			<div class="mb-3">
				<label for="observacoes_internas">Observações Internas / Vistorias</label>
				<textarea class="form-control" id="observacoes_internas" placeholder="Digite as observações internas / vistorias" name="observacoes_internas" rows="5"></textarea>
			</div>
			<div class="mb-3">
				<label for="condicao_de_pagamento">Condição de pagamento</label>
				<textarea class="form-control" id="condicao_de_pagamento" placeholder="Digite a condição de pagamento" name="condicao_de_pagamento" rows="5"></textarea>
			</div>
			<div class="mb-3">
				<div class="row">
					<div class="col-lg mb-lg-0 mb-3">
						<label for="quitado">Quitado?</label>
						<select class="form-control" id="quitado" name="quitado" required="">
							<option disabled="" selected="">Selecione uma opção</option>
							<option value="1">Sim</option>
							<option value="2">Não</option>
						</select>
					</div>
					<div class="col-lg">
						<label for="comissao_da_imobiliaria">Comissão da imobiliaria</label>
						<input type="text" class="form-control" id="comissao_da_imobiliaria" placeholder="Digite a comissão da imobiliária" name="comissao_da_imobiliaria">
					</div>
				</div>
			</div>
			<hr>
 
			 
 
			<strong>Localização</strong>
			<hr>
			<div class="mb-3">
				<div class="row">
					<div class="col-lg mb-lg-0 mb-3">
						<label for="rua">Rua</label>
						<input type="text" id="rua" placeholder="Digite a rua" class="form-control" name="rua">
					</div>
					<div class="col-lg mb-lg-0 mb-3">
						<label for="numero">Número</label>
						<input type="number" id="numero" placeholder="Digite o número" class="form-control" name="numero">
					</div>
					<div class="col-lg">
						<label for="bairro">Bairro</label>
						<input type="text" id="bairro" placeholder="Digite o bairro" class="form-control" name="bairro">
					</div>
				</div>
			</div>
			<div class="mb-3">
				<div class="row">
					<div class="col-lg mb-lg-0 mb-3">
						<label for="estado">Estado</label>
						<select class="form-control" id="estado" name="estado" required=""><option selected="" value="" disabled="">Selecione o estado</option><option value="Acre">Acre</option><option value="Alagoas">Alagoas</option><option value="Amazonas">Amazonas</option><option value="Amapá">Amapá</option><option value="Bahia">Bahia</option><option value="Ceará">Ceará</option><option value="Distrito Federal">Distrito Federal</option><option value="Espírito Santo">Espírito Santo</option><option value="Goiás">Goiás</option><option value="Maranhão">Maranhão</option><option value="Minas Gerais">Minas Gerais</option><option value="Mato Grosso do Sul">Mato Grosso do Sul</option><option value="Mato Grosso">Mato Grosso</option><option value="Pará">Pará</option><option value="Paraíba">Paraíba</option><option value="Pernambuco">Pernambuco</option><option value="Piauí">Piauí</option><option value="Paraná">Paraná</option><option value="Rio de Janeiro">Rio de Janeiro</option><option value="Rio Grande do Norte">Rio Grande do Norte</option><option value="Rondônia">Rondônia</option><option value="Roraima">Roraima</option><option value="Rio Grande do Sul">Rio Grande do Sul</option><option value="Santa Catarina">Santa Catarina</option><option value="Sergipe">Sergipe</option><option value="São Paulo">São Paulo</option><option value="Tocantins">Tocantins</option></select>
					</div>
					<div class="col-lg">
						<label for="cidade">Cidade</label>
						<select class="form-control" id="cidade" name="cidade" required=""><option selected="" value="" disabled="">Selecione a cidade</option></select>
					</div>
				</div>
			</div>
			<hr>
			<strong>Informações detalhadas</strong>
			<hr>
			<div class="mb-3">
				<div class="row">
					<div class="col-lg mb-lg-0 mb-3">
						<label>Dormitórios</label>
						<input type="number" class="form-control" name="dormitorio">
					</div>
					<div class="col-lg mb-lg-0 mb-3">
						<label>Suites</label>
						<input type="number" class="form-control" name="suite">
					</div>
					<div class="col-lg mb-lg-0 mb-3">
						<label>Suites c/closet</label>
						<input type="number" class="form-control" name="suite_c_closet">
					</div>
				</div>
				<div class="row">
					<div class="col-lg mb-lg-0 mb-3">
						<label>Demi-suites</label>
						<input type="number" class="form-control" name="demi_suite">
					</div>
					<div class="col-lg mb-lg-0 mb-3">
						<label>Salas</label>
						<input type="number" class="form-control" name="sala">
					</div>
					<div class="col-lg mb-lg-0 mb-3">
						<label>Sala de estar</label>
						<input type="number" class="form-control" name="sala_de_estar">
					</div>
				</div>
				<div class="row">
					<div class="col-lg mb-lg-0 mb-3">
						<label>Sala de TV</label>
						<input type="number" class="form-control" name="sala_de_tv">
					</div>
					<div class="col-lg mb-lg-0 mb-3">
						<label>Garagens</label>
						<input type="number" class="form-control" name="garagem">
					</div>
					<div class="col-lg mb-lg-0 mb-3">
						<label>Garagens descobertas</label>
						<input type="number" class="form-control" name="garagem_descoberta">
					</div>
				</div>
				<div class="row">
					<div class="col-lg mb-lg-0 mb-3">
						<label>Banheiros</label>
						<input type="number" class="form-control" name="banheiro">
					</div>
					<div class="col-lg mb-lg-0 mb-3">
						<label>N° de andares</label>
						<input type="number" class="form-control" name="andar">
					</div>
					<div class="col-lg mb-lg-0 mb-3">
						<label>Elevadores</label>
						<input type="number" class="form-control" name="elevador">
					</div>
				</div>
			</div>
			<hr>
			<strong>Destaques</strong>
			<hr>
			<div class="mb-3">
				<p><strong class="small">Espaço Externo</strong></p>
				<div class="form-check form-check-inline">
					<input id="checkbox_1" class="form-check-input" type="checkbox" name="edicula">
					<label class="form-check-label" for="checkbox_1">Edícula</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_2" class="form-check-input" type="checkbox" name="horta">
					<label class="form-check-label" for="checkbox_2">Horta</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_3" class="form-check-input" type="checkbox" name="jardim">
					<label class="form-check-label" for="checkbox_3">Jardim</label>
				</div>
			</div>
			<div class="mb-3">
				<p><strong class="small">Espaço Interno</strong></p>
				<div class="form-check form-check-inline">
					<input id="checkbox_4" class="form-check-input" type="checkbox" name="area_de_servico">
					<label class="form-check-label" for="checkbox_4">Área de Serviço</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_5" class="form-check-input" type="checkbox" name="bar">
					<label class="form-check-label" for="checkbox_5">Bar</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_6" class="form-check-input" type="checkbox" name="biblioteca">
					<label class="form-check-label" for="checkbox_6">Biblioteca</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_7" class="form-check-input" type="checkbox" name="closet">
					<label class="form-check-label" for="checkbox_7">Closet</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_8" class="form-check-input" type="checkbox" name="copa">
					<label class="form-check-label" for="checkbox_8">Copa</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_9" class="form-check-input" type="checkbox" name="despensa">
					<label class="form-check-label" for="checkbox_9">Despensa</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_10" class="form-check-input" type="checkbox" name="escritorio">
					<label class="form-check-label" for="checkbox_10">Escritório</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_11" class="form-check-input" type="checkbox" name="lareira">
					<label class="form-check-label" for="checkbox_11">Lareira</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_12" class="form-check-input" type="checkbox" name="sala_de_ginastica">
					<label class="form-check-label" for="checkbox_12">Sala de Ginástica</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_13" class="form-check-input" type="checkbox" name="sala_de_jantar">
					<label class="form-check-label" for="checkbox_13">Sala de Jantar</label>
				</div>
			</div>
			<div class="mb-3">
				<p><strong class="small">Condomínio</strong></p>
				<div class="form-check form-check-inline">
					<input id="checkbox_14" class="form-check-input" type="checkbox" name="acesso_a_deficiente">
					<label class="form-check-label" for="checkbox_14">Acesso à Deficientes</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_15" class="form-check-input" type="checkbox" name="gerador_de_energia">
					<label class="form-check-label" for="checkbox_15">Gerador de Energia</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_16" class="form-check-input" type="checkbox" name="guarita">
					<label class="form-check-label" for="checkbox_16">Guarita</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_17" class="form-check-input" type="checkbox" name="lavanderia_coletiva">
					<label class="form-check-label" for="checkbox_17">Lavanderia Coletiva</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_18" class="form-check-input" type="checkbox" name="medicao">
					<label class="form-check-label" for="checkbox_18">Medição</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_19" class="form-check-input" type="checkbox" name="agua_individual">
					<label class="form-check-label" for="checkbox_19">Água Individual</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_20" class="form-check-input" type="checkbox" name="portaria_24_horas">
					<label class="form-check-label" for="checkbox_20">Portaria 24 Horas</label>
				</div>
			</div>
			<div class="mb-3">
				<p><strong class="small">Lazer/Entretenimento</strong></p>
				<div class="form-check form-check-inline">
					<input id="checkbox_21" class="form-check-input" type="checkbox" name="bicicletario">
					<label class="form-check-label" for="checkbox_21">Bicicletário</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_22" class="form-check-input" type="checkbox" name="churrasqueira">
					<label class="form-check-label" for="checkbox_22">Churrasqueira</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_23" class="form-check-input" type="checkbox" name="ducha_externa">
					<label class="form-check-label" for="checkbox_23">Ducha externa</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_24" class="form-check-input" type="checkbox" name="piscina">
					<label class="form-check-label" for="checkbox_24">Piscina</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_25" class="form-check-input" type="checkbox" name="playground">
					<label class="form-check-label" for="checkbox_25">Playground</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_26" class="form-check-input" type="checkbox" name="quadra_de_esportes">
					<label class="form-check-label" for="checkbox_26">Quadra de Esportes</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_27" class="form-check-input" type="checkbox" name="quadra_tenis">
					<label class="form-check-label" for="checkbox_27">Quadra Tênis</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_28" class="form-check-input" type="checkbox" name="sala_ginastica_fitness">
					<label class="form-check-label" for="checkbox_28">Sala Ginástica/Fitness</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_29" class="form-check-input" type="checkbox" name="salao_de_festas">
					<label class="form-check-label" for="checkbox_29">Salão de Festas</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_30" class="form-check-input" type="checkbox" name="salao_de_jogos">
					<label class="form-check-label" for="checkbox_30">Salão de Jogos</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_31" class="form-check-input" type="checkbox" name="sauna">
					<label class="form-check-label" for="checkbox_31">Sauna</label>
				</div>
			</div>
			<div class="mb-3">
				<p><strong class="small">Segurança</strong></p>
				<div class="form-check form-check-inline">
					<input id="checkbox_32" class="form-check-input" type="checkbox" name="alarme">
					<label class="form-check-label" for="checkbox_32">Alarme</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_33" class="form-check-input" type="checkbox" name="camera_de_vigilancia">
					<label class="form-check-label" for="checkbox_33">Câmera de vigilância</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_34" class="form-check-input" type="checkbox" name="fechadura_reforcada">
					<label class="form-check-label" for="checkbox_34">Fechadura reforçada</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_35" class="form-check-input" type="checkbox" name="interfone">
					<label class="form-check-label" for="checkbox_35">Interfone</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_36" class="form-check-input" type="checkbox" name="muro_com_cerca_eletrica">
					<label class="form-check-label" for="checkbox_36">Muro com cerca elétrica</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_37" class="form-check-input" type="checkbox" name="portao_eletronico">
					<label class="form-check-label" for="checkbox_37">Portão Eletrônico</label>
				</div>
				<div class="form-check form-check-inline">
					<input id="checkbox_38" class="form-check-input" type="checkbox" name="vigilancia_24_horas">
					<label class="form-check-label" for="checkbox_38">Vigilância 24 horas</label>
				</div>
			</div>



			<hr>
			<strong>Galeria de Imagens</strong>
			<hr>
			<div class="mb-2">
				<div class="row" style="margin-bottom: 20px">
					<div class="col-lg mb-lg-10 mb-10">
						<label for="imagens">Selecione as imagens</label>
						<div class="alert alert-danger" id="imageUploadAlert"></div>
						
						<!--<input type="file" id="imagens" class="form-control" name="imagens[]" multiple>-->
						<div class=" mb-lg-10 mb-10 " id="galeriaContainer" >
							<div class="" id="galeriaImagensContainer ">
								<div class="grid">
									<div class="item  image-upload">
										<label for="uploadFileSelect">
											<div class="upload-icon">
												<img class="icon" src="assets/images/upload-file.png">
												<img class="prev" src="">
											</div>
										</label>
										<div class="remove hideElement"  ><i class="fa fa-times"></i></div>
										<input type="text" class="posicao" value="1" name="imagem[1][posicao]">
										<input id="uploadFileSelect" name="imagem[1][arquivo]" type="file" class=""  accept="image/png, image/gif, image/jpeg, image/webp"  multiple/>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="mb-3">
				<div class="row"> 
					<div class="col-lg-12 mb-3">
						<label for="imagensMarcaDagua">Deseja adicionar marca d'agua com seu logotipo nas imagens</label>
						<select class="form-control" id="imagensMarcaDagua" name="imagensMarcaDagua" required="">
							<option value="sim">Sim</option>
							<option value="nao">Não</option>
						</select>
					</div>
				</div>
			</div>
		    <input type="hidden" name="cadastrar_imovel">
		    <input type="button" class="submit btn btn-primary " value="CADASTRAR IMÓVEL">
		</form>

								</div>
							</div>
						</div>
					</div>
                </div>
				
				<?php include 'estrutura/copy.php';?>	
            </div>
         </div>
    </div>
	<?php include 'estrutura/rodape.php';?>
	<?php include 'estrutura/_modal_admin.php';?>

	<script src="https://cdn.jsdelivr.net/npm/muuri@0.9.5/dist/muuri.min.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/web-animations-js@2.3.2/web-animations.min.js"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/velocity/1.5.0/velocity.min.js"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/hammer.js/2.0.8/hammer.min.js"></script>
	<link rel="stylesheet" type="text/css" href="assets/css/galeria-dragdrop.css?v=1.1.1"/>
	<style>
		#imageUploadAlert{display: none}
	</style>
	
	<script type="text/javascript">
		var dragCounter = 0;
		var docElem = document.documentElement;
		
		var dragSortOptions = {

		};
		var grid = new Muuri('.grid', {
			dragEnabled: true,
			layoutOnResize: true,
			action: 'swap',
			threshold: 50,
			layoutDuration: 400,
			
			layoutEasing: 'ease',
			dragStartPredicate: {
				distance: 10,
				delay: 100,
			},
			dragReleaseDuration: 400,
			dragReleseEasing: 'ease',
			showEasing: 'cubic-bezier(0.215, 0.61, 0.355, 1)',
			dragStartPredicate: function (item, event) {
				if (grid.getItems().indexOf(item) === 0) {
					return false;
				}
				var isRemoveAction = elementMatches(event.target, '.remove, .remove i');
				return !isRemoveAction ? Muuri.ItemDrag.defaultStartPredicate(item, event) : false;
				//return Muuri.ItemDrag.defaultStartPredicate(item, event);
			},
			dragSortPredicate: function (item) {
				var result = Muuri.ItemDrag.defaultSortPredicate(item, dragSortOptions);
				return result && result.index === 0 ? false : result;
			} 
		})
		.on('dragStart', function (item, event) {
			++dragCounter;
			docElem.classList.add('dragging');
			
		})
		.on('dragEnd', function (item, event) {
			if (--dragCounter < 1) {
				docElem.classList.remove('dragging');
				
			}
			//console.log(grid.getItems().indexOf(item));
			updateIndices();
		})
			.on('synchronize', function () {
				//console.log('Synced!');
			})
			.on('remove', function() {
				//grid.sort('id', { layout: false });
				updateIndices();
				grid.refreshSortData();
			})
				.on('layoutStart', function (items, isInstant) {
					console.log(items, isInstant);
					updateIndices();
				})
				.on('move', updateIndices)
				  
		function readURL(input, grid) {
			
				const files = input.files;
				for (var i = 0; i < files.length; i++){
					const file = files[i];
					//alert(file);
					const reader = new FileReader();
					reader.onload = function(e) { 
						var totalImagens = $(".grid .item").length;
							var itemElem = document.createElement('div');
							totalImagens = totalImagens + 1;
							
								//var image = document.getElementById('output');
								//image.src = URL.createObjectURL(e.target.files[0]);
								var items = '<div class="item image-upload" data-id="' + totalImagens + '">\
									<label for="imagem['+totalImagens+'][arquivo]">\
										<div class="upload-icon" style="border: none">\
											<img class="prev" style="display: block" src="'+ e.target.result+'">\
										</div>\
									</label>\
									<div class="remove"><i class="fa fa-times"></i></div>\
									<input type="text" class="posicao" value="'+totalImagens+'" name="imagem['+totalImagens+'][posicao]">\
									<input readonly id="imagem['+totalImagens+'][arquivo]" name="imagem['+totalImagens+'][arquivo]" type="text" value="'+ e.target.result+'"/>\
								</div> ';
							console.log(e);	
							itemElem.innerHTML = items; 
							var newItems = grid.add(itemElem);
							grid.show(newItems);
					}
					reader.readAsDataURL(file);
				}
				updateIndices();
		}
		
		

		$("body").on("change", "input[name='imagem[1][arquivo]']", function() {
			$("#imageUploadAlert").fadeOut(100);
			$("#imageUploadAlert").html('');
			
			var selection = document.getElementById('uploadFileSelect');
			for (var i=0; i< selection.files.length; i++) {
				//var ext = selection.files[i].name.substr(-3);
				var re = /(?:\.([^.]+))?$/;
				var ext = re.exec( selection.files[i].name )[1];
				//console.log(ext);
				if(ext!== "jpg" && ext!== "jpeg" && ext!== "png" && ext!== "bmp" && ext!== "webp")  {
					$("#imageUploadAlert").fadeIn(100);
					$("#imageUploadAlert").html('Ops, você selecionou um arquivo não permitido, por favor, selecione apenas imagens para continuar: .jpg, .png, .jpeg, .bmp, .webp');
					return false;
				}
				/*
					//se maior que 10 MB -> bytes to mb
					if(selection.files[i].size > 10000000) {
						$("#imageUploadAlert").fadeIn(100);
						$("#imageUploadAlert").html('Ops, uma das imagens selecionadas possuí mais de 10 MB, selecione imagens com menos de 10 MB.');
						return false;
					}
				*/
			}
			
			readURL(this, grid);
		});
		
			$("body").on("click", ".remove", function(e){
					//var gridItem = $(this).closest('div.item').remove();
					var gridItem 	= $(this).closest('div.muuri-item').attr('data-id');
					var gridItemEl 	= $(this).closest('div.muuri-item');
					
					var elem  = document.querySelectorAll('.item[data-id="'+gridItem+'"]'); 
					 
					console.log('item: '+elem);
					$(elem).fadeOut("normal", function() {
						$(this).closest('div.muuri-item').remove();
						grid.remove([elem], {removeElements: true});
						

						grid.refreshItems().layout();
						const currentItems = grid.getItems();
						grid.sort(currentItems);
					});
 			});
			
				$("body").on("click", ".prev", function() {
					return false;
				});


			function updateIndices() {
				grid.getItems().forEach(function (item, i) {
					item.getElement().setAttribute('data-id', i + 1);
					item.getElement().querySelector('.posicao').value = i + 1 ;
					//console.log( item.getElement().querySelector('.posicao').value );
				});
			}
 
		function elementMatches(element, selector) {
			var p = Element.prototype;
			return (p.matches || p.matchesSelector || p.webkitMatchesSelector || p.mozMatchesSelector || p.msMatchesSelector || p.oMatchesSelector).call(element, selector);
		}


		    $.getJSON('assets/estados_cidades.json', (data) => {
		        let items = [];
		        let options = '<option selected value disabled>Selecione o estado</option>';
		        for(val of data) {
		            options += '<option value="' + val.nome + '">' + val.nome + '</option>';
		        }
		        $('#estado').html(options);
		        $('#estado').change( () => {
		            let options_cidades = '<option selected value disabled>Selecione a cidade</option>';
		            let str = $('#estado').val();
		            for(val of data) {
		                if(val.nome == str) {
		                    for(val_city of val.cidades) {
		                        options_cidades += '<option value="' + val_city + '">' + val_city + '</option>';
		                    }
		                }
		            }
		            $('#cidade').html(options_cidades);
		        }).change();
		    });
	</script>
</body>

</html>
