<?php
require 'app/bootstrap.php';
$conectDB = connectDB();
$conectDB->exec("set names utf8mb4");
include '__valida_login.php';
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <title><?=$configSistema['sistema'];?> - Editando Imóveis</title>
	<?php
		include 'estrutura/__css.php';
	?>
</head>
<body>
    <div class="app ">
        <div class="layout  ">
			<?php
				include 'estrutura/topo.php';
				include '_menu.php'; 
			?>
            <div class="page-container">
                <div class="main-content">
                     
                   <div class="card  ">
                        <div class="card-body"> 
							 
							<div class="row">
								<div class="col-xs-12 col-lg-12">
									<h1> Editando Imóvel</h1>
 								</div> 
							</div>

				<?php
					if(!isset($_GET['imovel']))
					{
						echo '<h3>Este imóvel não foi localizado</h3>';
					}
					else
					{
						$imovelID    = stringInputCleaner($_GET['imovel']);

		 				$dadosImovel = findItem($conectDB, 'imovel', ' * ', array("codigo"=>$imovelID) );
						if(empty($dadosImovel->id))
						{
							echo '<h3>Este imóvel não foi localizado</h3>';
						}
						else
						{
							$imov_titulo = $dadosImovel->titulo;
							$imov_situacao = $dadosImovel->situacao;
							$imov_categoria = $dadosImovel->categoria;
							$imov_valor = $dadosImovel->valor;
							$imov_indice_de_reajuste_ao_consumidor = $dadosImovel->indice_de_reajuste_ao_consumidor;
							$imov_area_total = $dadosImovel->area_total;
							$imov_indice_cadastral = $dadosImovel->indice_cadastral;
							$imov_construtora = $dadosImovel->construtora;
							$imov_idade = $dadosImovel->idade;
							$imov_posicao = $dadosImovel->posicao;
							$imov_topografia = $dadosImovel->topografia;
							$imov_taxa_do_condominio = $dadosImovel->taxa_do_condominio;
							$imov_iptu = $dadosImovel->iptu;
							$imov_permuta = $dadosImovel->permuta;
							$imov_imovel_ocupado = $dadosImovel->imovel_ocupado;
							$imov_rua = $dadosImovel->rua;
							$imov_numero = $dadosImovel->numero;
							$imov_bairro = $dadosImovel->bairro;
							$imov_estado = $dadosImovel->estado;
							$imov_cidade = $dadosImovel->cidade;
							$imov_descricao_do_imovel = $dadosImovel->descricao_do_imovel;
							$imov_observacoes_internas = $dadosImovel->observacoes_internas;
							$imov_condicao_de_pagamento = $dadosImovel->condicao_de_pagamento;
							$imov_quitado = $dadosImovel->quitado;
							$imov_comissao_da_imobiliaria = $dadosImovel->comissao_da_imobiliaria;
							$imov_informacoes_documentacao = $dadosImovel->informacoes_documentacao;
							$imov_dormitorio = $dadosImovel->dormitorio;
							$imov_suite = $dadosImovel->suite;
							$imov_suite_c_closet = $dadosImovel->suite_c_closet;
							$imov_demi_suite = $dadosImovel->demi_suite;
							$imov_sala = $dadosImovel->sala;
							$imov_sala_de_estar = $dadosImovel->sala_de_estar;
							$imov_sala_de_tv = $dadosImovel->sala_de_tv;
							$imov_garagem = $dadosImovel->garagem;
							$imov_garagem_descoberta = $dadosImovel->garagem_descoberta;
							$imov_banheiro = $dadosImovel->banheiro;
							$imov_andar = $dadosImovel->andar;
							$imov_elevador = $dadosImovel->elevador;
							$imov_edicula = $dadosImovel->edicula;
							$imov_horta = $dadosImovel->horta;
							$imov_jardim = $dadosImovel->jardim;
							$imov_area_de_servico = $dadosImovel->area_de_servico;
							$imov_bar = $dadosImovel->bar;
							$imov_biblioteca = $dadosImovel->biblioteca;
							$imov_closet = $dadosImovel->closet;
							$imov_copa = $dadosImovel->copa;
							$imov_despensa = $dadosImovel->despensa;
							$imov_escritorio = $dadosImovel->escritorio;
							$imov_lareira = $dadosImovel->lareira;
							$imov_sala_de_ginastica = $dadosImovel->sala_de_ginastica;
							$imov_sala_de_jantar = $dadosImovel->sala_de_jantar;
							$imov_acesso_a_deficiente = $dadosImovel->acesso_a_deficiente;
							$imov_gerador_de_energia = $dadosImovel->gerador_de_energia;
							$imov_guarita = $dadosImovel->guarita;
							$imov_lavanderia_coletiva = $dadosImovel->lavanderia_coletiva;
							$imov_medicao = $dadosImovel->medicao;
							$imov_agua_individual = $dadosImovel->agua_individual;
							$imov_portaria_24_horas = $dadosImovel->portaria_24_horas;
							$imov_bicicletario = $dadosImovel->bicicletario;
							$imov_churrasqueira = $dadosImovel->churrasqueira;
							$imov_ducha_externa = $dadosImovel->ducha_externa;
							$imov_piscina = $dadosImovel->piscina;
							$imov_playground = $dadosImovel->playground;
							$imov_quadra_de_esportes = $dadosImovel->quadra_de_esportes;
							$imov_quadra_tenis = $dadosImovel->quadra_tenis;
							$imov_sala_ginastica_fitness = $dadosImovel->sala_ginastica_fitness;
							$imov_salao_de_festas = $dadosImovel->salao_de_festas;
							$imov_salao_de_jogos = $dadosImovel->salao_de_jogos;
							$imov_sauna = $dadosImovel->sauna;
							$imov_alarme = $dadosImovel->alarme;
							$imov_camera_de_vigilancia = $dadosImovel->camera_de_vigilancia;
							$imov_fechadura_reforcada = $dadosImovel->fechadura_reforcada;
							$imov_interfone = $dadosImovel->interfone;
							$imov_muro_com_cerca_eletrica = $dadosImovel->muro_com_cerca_eletrica;
							$imov_portao_eletronico = $dadosImovel->portao_eletronico;
							$imov_vigilancia_24_horas = $dadosImovel->vigilancia_24_horas;
						}
					}
		 		?>
 			<div class="row">
				<div class="col-md-12">
					<div class="card shadow p-4">
 
						<ul class="nav nav-tabs">
							<li class="nav-item <?php if(!isset($_GET['imgs'])) { echo 'active show'; } ?>">
								<a  href="#1" data-target="#aba1" data-toggle="tab" class="nav-link  <?php if(!isset($_GET['imgs'])) { echo 'active'; } ?>">Informações</a>
							</li>
								<li class="tabImagens nav-item <?php if(isset($_GET['imgs'])) { echo 'active show'; } ?>" id="" >
									<a href="#2" data-target="#aba2" data-toggle="tab" class="tabImagens nav-link <?php if(isset($_GET['imgs'])) { echo 'active'; } ?>">Imagens <i class="fas fa-circle-notch fa-spin" id="imageTabLoad"></i></a>
								</li>
						</ul> 

						<div class="tab-content m-t-15">
							<div class="tab-pane fade <?php if(!isset($_GET['imgs'])) { echo 'show active'; } ?>" id="aba1" >
								<form method="POST" enctype="multipart/form-data" action="app/imovel/edita">
									<strong>Informações básicas</strong>
									<hr> 
									<div class="mb-3">
										<label for="titulo">Título do imóvel</label>
										<input type="text" class="form-control" id="titulo" placeholder="Digite o título" name="titulo" <?php if(!empty($imov_titulo)) { echo 'value="'.$imov_titulo.'"'; } ?> required>
									</div>
									<div class="mb-3">
										<div class="row">
											<div class="col-lg mb-lg-0 mb-3">
												<label for="situacao">Para vender ou para alugar?</label>
												<select class="form-control" id="situacao" name="situacao" required>
													<option disabled selected>Selecione se é aluguel ou venda</option>
													<option value="1" <?=( (int)$imov_situacao == 1) ? ("selected") : ("");?>>Aluguel</option>
													<option value="2" <?=( (int)$imov_situacao == 2) ? ("selected") : ("");?>>Venda</option>
												</select>
											</div>
											<div class="col-lg">
												<label for="categoria">Qual a categoria?</label>
										        <select class="form-control" id="categoria" name="categoria" required="">
													<option disabled="" selected="">Selecione a categoria</option>
													<option value="1" <?=( (int)$imov_categoria == 1) ? ("selected") : ("");?>>Apartamento</option>
													<option value="2" <?=( (int)$imov_categoria == 2) ? ("selected") : ("");?>>Área Rural</option>
													<option value="3" <?=( (int)$imov_categoria == 3) ? ("selected") : ("");?>>Barracão</option>
													<option value="4" <?=( (int)$imov_categoria == 4) ? ("selected") : ("");?>>Casa</option>
													<option value="5" <?=( (int)$imov_categoria == 5) ? ("selected") : ("");?>>Chácara</option>
													<option value="6" <?=( (int)$imov_categoria == 6) ? ("selected") : ("");?>>Cobertura</option>
													<option value="7" <?=( (int)$imov_categoria == 7) ? ("selected") : ("");?>>Comércio</option>
													<option value="8" <?=( (int)$imov_categoria == 8) ? ("selected") : ("");?>>Fazenda</option>
													<option value="9" <?=( (int)$imov_categoria == 9) ? ("selected") : ("");?>>Prédio</option>
													<option value="10" <?=( (int)$imov_categoria == 10) ? ("selected") : ("");?>>Sala Comercial</option>
													<option value="11" <?=( (int)$imov_categoria == 11) ? ("selected") : ("");?>>Sítio</option>
													<option value="12" <?=( (int)$imov_categoria == 12) ? ("selected") : ("");?>>Sobrado</option>
													<option value="13" <?=( (int)$imov_categoria == 13) ? ("selected") : ("");?>>Terreno</option>
												</select>
											</div>
										</div>
									</div>
									<div class="mb-3">
										<div class="row">
											<div class="col-lg mb-lg-0 mb-3">
												<label for="valor">Valor</label>
												<input type="text" class="form-control moeda" id="valor" placeholder="Digite o valor" name="valor" <?php if(!empty($imov_valor)) { echo 'value="'.$imov_valor.'"'; } ?>>
											</div>
											<div class="col-lg mb-lg-0 mb-3">
												<label for="indice_de_reajuste_ao_consumidor">Indíce de reajuste ao consumidor</label>
												<select class="form-control" id="indice_de_reajuste_ao_consumidor" name="indice_de_reajuste_ao_consumidor" required>
													<option disabled selected>Selecione uma opção</option>
													<option value="1" <?=( (int)$imov_indice_de_reajuste_ao_consumidor == 1) ? ("selected") : ("");?>>IGPM</option>
													<option value="2" <?=( (int)$imov_indice_de_reajuste_ao_consumidor == 2) ? ("selected") : ("");?>>INPC</option>
												</select>
											</div>
											<div class="col-lg">
												<label for="area_total">Área total</label>
												<input type="number" class="form-control" id="area_total" placeholder="Digite a área total" name="area_total" <?php if(!empty($imov_area_total)) { echo 'value="'.$imov_area_total.'"'; } ?>>
											</div>
										</div>
									</div>
									<div class="mb-3">
										<div class="row">
											<div class="col-lg mb-lg-0 mb-3">
												<label for="indice_cadastral">Índice Cadastral</label>
												<select class="form-control" id="indice_cadastral" name="indice_cadastral" required>
													<option disabled selected>Selecione uma opção</option>
													<option value="1" <?=( (int)$imov_indice_cadastral == 1) ? ("selected") : ("");?>>Pré-lançamento</option>
													<option value="2" <?=( (int)$imov_indice_cadastral == 2) ? ("selected") : ("");?>>Lançamento</option>
													<option value="3" <?=( (int)$imov_indice_cadastral == 3) ? ("selected") : ("");?>>Pronto/revenda</option>
												</select>
											</div>
											<div class="col-lg mb-lg-0 mb-3">
												<label for="construtora">Construtora</label>
												<input type="text" class="form-control" id="construtora" placeholder="Digite a construtora" name="construtora" <?php if(!empty($imov_construtora)) { echo 'value="'.$imov_construtora.'"'; } ?>>
											</div>
											<div class="col-lg">
												<label for="idade">Idade</label>
												<input type="text" class="form-control" id="idade" placeholder="Digite a idade" name="idade" <?php if(!empty($imov_idade)) { echo 'value="'.$imov_idade.'"'; } ?>>
											</div>
										</div>
									</div>
									<div class="mb-3">
										<div class="row">
											<div class="col-lg mb-lg-0 mb-3">
												<label for="posicao">Posição</label>
												<select class="form-control" id="posicao" name="posicao" required>
													<option disabled selected>Selecione uma opção</option>
													<option value="1" <?=( (int)$imov_posicao == 1) ? ("selected") : ("");?>>Frente</option>
													<option value="2" <?=( (int)$imov_posicao == 2) ? ("selected") : ("");?>>Fundos</option>
													<option value="3" <?=( (int)$imov_posicao == 3) ? ("selected") : ("");?>>Meio</option>
													<option value="4" <?=( (int)$imov_posicao == 4) ? ("selected") : ("");?>>Lateral</option>
												</select>
											</div>
											<div class="col-lg mb-lg-0 mb-3">
												<label for="topografia">Topografia</label>
												<select class="form-control" id="topografia" name="topografia" required>
													<option disabled selected>Selecione uma opção</option>
													<option value="1" <?=( (int)$imov_topografia == 1) ? ("selected") : ("");?>>Aclive</option>
													<option value="2" <?=( (int)$imov_topografia == 2) ? ("selected") : ("");?>>Declive</option>
													<option value="3" <?=( (int)$imov_topografia == 3) ? ("selected") : ("");?>>Plano</option>
												</select>
											</div>
											<div class="col-lg">
												<label for="taxa_do_condominio">Taxa do Condomínio</label>
												<input type="text" class="form-control money" id="taxa_do_condominio" placeholder="Digite a taxa do condomínio" name="taxa_do_condominio" <?php if(!empty($imov_taxa_do_condominio)) { echo 'value="'.$imov_taxa_do_condominio.'"'; } ?>>
											</div>
										</div>
									</div>
									<div class="mb-3">
										<div class="row">
											<div class="col-lg mb-lg-0 mb-3">
												<label for="iptu">IPTU</label>
												<input type="number" class="form-control" id="iptu" placeholder="Digite o IPTU" name="iptu" <?php if(!empty($imov_iptu)) { echo 'value="'.$imov_iptu.'"'; } ?>>
											</div>
											<div class="col-lg mb-lg-0 mb-3">
												<label for="permuta">Permuta</label>
												<select class="form-control" id="permuta" name="permuta" required>
													<option disabled selected>Selecione uma opção</option>
													<option value="1" <?=( (int)$imov_permuta == 1) ? ("selected") : ("");?>>Sim</option>
													<option value="2" <?=( (int)$imov_permuta == 2) ? ("selected") : ("");?>>Não</option>
												</select>
											</div>
											<div class="col-lg">
												<label for="imovel_ocupado">Imóvel ocupado?</label>
												<select class="form-control" id="imovel_ocupado" name="imovel_ocupado" required>
													<option disabled selected>Selecione uma opção</option>
													<option value="1" <?=( (int)$imov_imovel_ocupado == 1) ? ("selected") : ("");?>>Em construção</option>
													<option value="2" <?=( (int)$imov_imovel_ocupado == 2) ? ("selected") : ("");?>>Inquilino</option>
													<option value="3" <?=( (int)$imov_imovel_ocupado == 3) ? ("selected") : ("");?>>Proprietário reside</option>
													<option value="4" <?=( (int)$imov_imovel_ocupado == 4) ? ("selected") : ("");?>>Vazio / Lançamento / Planta</option>
												</select>
											</div>
										</div>
									</div>
									<div class="mb-3">
										<label for="descricao_do_imovel">Texto complementar - Descrição do imóvel</label>
										<textarea class="form-control" id="descricao_do_imovel" placeholder="Digite a descrição do imóvel" name="descricao_do_imovel" rows="5"><?php if(!empty($imov_descricao_do_imovel)) { echo $imov_descricao_do_imovel; } ?></textarea>
									</div>
									<hr>
									<strong>Informações internas</strong>
									<hr>
									<div class="mb-3">
										<label for="observacoes_internas">Observações Internas / Vistorias</label>
										<textarea class="form-control" id="observacoes_internas" placeholder="Digite as observações internas / vistorias" name="observacoes_internas" rows="5"><?php if(!empty($imov_observacoes_internas)) { echo $imov_observacoes_internas; } ?></textarea>
									</div>
									<div class="mb-3">
										<label for="condicao_de_pagamento">Condição de pagamento</label>
										<textarea class="form-control" id="condicao_de_pagamento" placeholder="Digite a condição de pagamento" name="condicao_de_pagamento" rows="5"><?php if(!empty($imov_condicao_de_pagamento)) { echo $imov_condicao_de_pagamento; } ?></textarea>
									</div>
									<div class="mb-3">
										<div class="row">
											<div class="col-lg mb-lg-0 mb-3">
												<label for="quitado">Quitado?</label>
												<select class="form-control" id="quitado" name="quitado" required>
													<option disabled selected>Selecione uma opção</option>
													<option value="1" <?=( (int)$imov_quitado == 1) ? ("selected") : ("");?>>Sim</option>
													<option value="2" <?=( (int)$imov_quitado == 2) ? ("selected") : ("");?>>Não</option>
												</select>
											</div>
											<div class="col-lg">
												<label for="comissao_da_imobiliaria">Comissão da imobiliaria</label>
												<input type="text" class="form-control" id="comissao_da_imobiliaria" placeholder="Digite a comissão da imobiliária" name="comissao_da_imobiliaria" <?php if(!empty($imov_comissao_da_imobiliaria)) { echo 'value="'.$imov_comissao_da_imobiliaria.'"'; } ?>>
											</div>
										</div>
									</div>
									<hr>
									 
									<!--
									<strong>Galeria de Imagens</strong>
									<hr>
									<div class="mb-3">
										<label for="imagens">Selecione as imagens</label>
										<input type="file" id="imagens" class="form-control" name="imagens[]" multiple>
									</div>
									
									<hr>-->
									<strong>Localização</strong>
									<hr>
									<div class="mb-3">
										<div class="row">
											<div class="col-lg mb-lg-0 mb-3">
												<label for="rua">Rua</label>
												<input type="text" id="rua" placeholder="Digite a rua" class="form-control" name="rua" <?php if(!empty($imov_rua)) { echo 'value="'.$imov_rua.'"'; } ?>>
											</div>
											<div class="col-lg mb-lg-0 mb-3">
												<label for="numero">Número</label>
												<input type="number" id="numero" placeholder="Digite o número" class="form-control" name="numero" <?php if(!empty($imov_numero)) { echo 'value="'.$imov_numero.'"'; } ?>>
											</div>
											<div class="col-lg">
												<label for="bairro">Bairro</label>
												<input type="text" id="bairro" placeholder="Digite o bairro" class="form-control" name="bairro" <?php if(!empty($imov_bairro)) { echo 'value="'.$imov_bairro.'"'; } ?>>
											</div>
										</div>
									</div>
									<div class="mb-3">
										<div class="row">
											<div class="col-lg mb-lg-0 mb-3">
												<label for="estado">Estado</label>
												<select class="form-control" id="estado" name="estado" required></select>
											</div>
											<div class="col-lg">
												<label for="cidade">Cidade</label>
												<select class="form-control" id="cidade" name="cidade" required></select>
											</div>
										</div>
									</div>
									<hr>
									<strong>Informações detalhadas</strong>
									<hr>
									<div class="mb-3">
										<div class="row">
											<div class="col-lg mb-lg-0 mb-3">
												<label>Dormitórios</label>
												<input type="number" class="form-control" name="dormitorio" <?php if(!empty($imov_dormitorio)) { echo 'value="'.$imov_dormitorio.'"'; } ?>>
											</div>
											<div class="col-lg mb-lg-0 mb-3">
												<label>Suites</label>
												<input type="number" class="form-control" name="suite" <?php if(!empty($imov_suite)) { echo 'value="'.$imov_suite.'"'; } ?>>
											</div>
											<div class="col-lg mb-lg-0 mb-3">
												<label>Suites c/closet</label>
												<input type="number" class="form-control" name="suite_c_closet" <?php if(!empty($imov_suite_c_closet)) { echo 'value="'.$imov_suite_c_closet.'"'; } ?>>
											</div>
										</div>
										<div class="row">
											<div class="col-lg mb-lg-0 mb-3">
												<label>Demi-suites</label>
												<input type="number" class="form-control" name="demi_suite" <?php if(!empty($imov_demi_suite)) { echo 'value="'.$imov_demi_suite.'"'; } ?>>
											</div>
											<div class="col-lg mb-lg-0 mb-3">
												<label>Salas</label>
												<input type="number" class="form-control" name="sala" <?php if(!empty($imov_sala)) { echo 'value="'.$imov_sala.'"'; } ?>>
											</div>
											<div class="col-lg mb-lg-0 mb-3">
												<label>Sala de estar</label>
												<input type="number" class="form-control" name="sala_de_estar" <?php if(!empty($imov_sala_de_estar)) { echo 'value="'.$imov_sala_de_estar.'"'; } ?>>
											</div>
										</div>
										<div class="row">
											<div class="col-lg mb-lg-0 mb-3">
												<label>Sala de TV</label>
												<input type="number" class="form-control" name="sala_de_tv" <?php if(!empty($imov_sala_de_tv)) { echo 'value="'.$imov_sala_de_tv.'"'; } ?>>
											</div>
											<div class="col-lg mb-lg-0 mb-3">
												<label>Garagens</label>
												<input type="number" class="form-control" name="garagem" <?php if(!empty($imov_garagem)) { echo 'value="'.$imov_garagem.'"'; } ?>>
											</div>
											<div class="col-lg mb-lg-0 mb-3">
												<label>Garagens descobertas</label>
												<input type="number" class="form-control" name="garagem_descoberta" <?php if(!empty($imov_garagem_descoberta)) { echo 'value="'.$imov_garagem_descoberta.'"'; } ?>>
											</div>
										</div>
										<div class="row">
											<div class="col-lg mb-lg-0 mb-3">
												<label>Banheiros</label>
												<input type="number" class="form-control" name="banheiro" <?php if(!empty($imov_banheiro)) { echo 'value="'.$imov_banheiro.'"'; } ?>>
											</div>
											<div class="col-lg mb-lg-0 mb-3">
												<label>N° de andares</label>
												<input type="number" class="form-control" name="andar" <?php if(!empty($imov_andar)) { echo 'value="'.$imov_andar.'"'; } ?>>
											</div>
											<div class="col-lg mb-lg-0 mb-3">
												<label>Elevadores</label>
												<input type="number" class="form-control" name="elevador" <?php if(!empty($imov_elevador)) { echo 'value="'.$imov_elevador.'"'; } ?>>
											</div>
										</div>
									</div>
									<hr>
									<strong>Destaques</strong>
									<hr>
									<div class="mb-3">
										<p><strong class="small">Espaço Externo</strong></p>
										<div class="form-check form-check-inline">
											<input id="checkbox_1" class="form-check-input" type="checkbox" name="edicula" <?php if(!empty($imov_edicula)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_1">Edícula</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_2" class="form-check-input" type="checkbox" name="horta" <?php if(!empty($imov_horta)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_2">Horta</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_3" class="form-check-input" type="checkbox" name="jardim" <?php if(!empty($imov_jardim)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_3">Jardim</label>
										</div>
									</div>
									<div class="mb-3">
										<p><strong class="small">Espaço Interno</strong></p>
										<div class="form-check form-check-inline">
											<input id="checkbox_4" class="form-check-input" type="checkbox" name="area_de_servico" <?php if(!empty($imov_area_de_servico)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_4">Área de Serviço</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_5" class="form-check-input" type="checkbox" name="bar" <?php if(!empty($imov_bar)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_5">Bar</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_6" class="form-check-input" type="checkbox" name="biblioteca" <?php if(!empty($imov_biblioteca)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_6">Biblioteca</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_7" class="form-check-input" type="checkbox" name="closet" <?php if(!empty($imov_closet)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_7">Closet</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_8" class="form-check-input" type="checkbox" name="copa" <?php if(!empty($imov_copa)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_8">Copa</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_9" class="form-check-input" type="checkbox" name="despensa" <?php if(!empty($imov_despensa)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_9">Despensa</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_10" class="form-check-input" type="checkbox" name="escritorio" <?php if(!empty($imov_escritorio)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_10">Escritório</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_11" class="form-check-input" type="checkbox" name="lareira" <?php if(!empty($imov_lareira)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_11">Lareira</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_12" class="form-check-input" type="checkbox" name="sala_de_ginastica" <?php if(!empty($imov_sala_de_ginastica)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_12">Sala de Ginástica</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_13" class="form-check-input" type="checkbox" name="sala_de_jantar" <?php if(!empty($imov_sala_de_jantar)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_13">Sala de Jantar</label>
										</div>
									</div>
									<div class="mb-3">
										<p><strong class="small">Condomínio</strong></p>
										<div class="form-check form-check-inline">
											<input id="checkbox_14" class="form-check-input" type="checkbox" name="acesso_a_deficiente" <?php if(!empty($imov_acesso_a_deficiente)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_14">Acesso à Deficientes</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_15" class="form-check-input" type="checkbox" name="gerador_de_energia" <?php if(!empty($imov_gerador_de_energia)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_15">Gerador de Energia</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_16" class="form-check-input" type="checkbox" name="guarita" <?php if(!empty($imov_guarita)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_16">Guarita</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_17" class="form-check-input" type="checkbox" name="lavanderia_coletiva" <?php if(!empty($imov_lavanderia_coletiva)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_17">Lavanderia Coletiva</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_18" class="form-check-input" type="checkbox" name="medicao" <?php if(!empty($imov_medicao)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_18">Medição</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_19" class="form-check-input" type="checkbox" name="agua_individual" <?php if(!empty($imov_agua_individual)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_19">Água Individual</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_20" class="form-check-input" type="checkbox" name="portaria_24_horas" <?php if(!empty($imov_portaria_24_horas)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_20">Portaria 24 Horas</label>
										</div>
									</div>
									<div class="mb-3">
										<p><strong class="small">Lazer/Entretenimento</strong></p>
										<div class="form-check form-check-inline">
											<input id="checkbox_21" class="form-check-input" type="checkbox" name="bicicletario" <?php if(!empty($imov_bicicletario)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_21">Bicicletário</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_22" class="form-check-input" type="checkbox" name="churrasqueira" <?php if(!empty($imov_churrasqueira)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_22">Churrasqueira</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_23" class="form-check-input" type="checkbox" name="ducha_externa" <?php if(!empty($imov_ducha_externa)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_23">Ducha externa</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_24" class="form-check-input" type="checkbox" name="piscina" <?php if(!empty($imov_piscina)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_24">Piscina</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_25" class="form-check-input" type="checkbox" name="playground" <?php if(!empty($imov_playground)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_25">Playground</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_26" class="form-check-input" type="checkbox" name="quadra_de_esportes" <?php if(!empty($imov_quadra_de_esportes)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_26">Quadra de Esportes</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_27" class="form-check-input" type="checkbox" name="quadra_tenis" <?php if(!empty($imov_quadra_tenis)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_27">Quadra Tênis</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_28" class="form-check-input" type="checkbox" name="sala_ginastica_fitness" <?php if(!empty($imov_sala_ginastica_fitness)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_28">Sala Ginástica/Fitness</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_29" class="form-check-input" type="checkbox" name="salao_de_festas" <?php if(!empty($imov_salao_de_festas)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_29">Salão de Festas</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_30" class="form-check-input" type="checkbox" name="salao_de_jogos" <?php if(!empty($imov_salao_de_jogos)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_30">Salão de Jogos</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_31" class="form-check-input" type="checkbox" name="sauna" <?php if(!empty($imov_sauna)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_31">Sauna</label>
										</div>
									</div>
									<div class="mb-3">
										<p><strong class="small">Segurança</strong></p>
										<div class="form-check form-check-inline">
											<input id="checkbox_32" class="form-check-input" type="checkbox" name="alarme" <?php if(!empty($imov_alarme)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_32">Alarme</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_33" class="form-check-input" type="checkbox" name="camera_de_vigilancia" <?php if(!empty($imov_camera_de_vigilancia)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_33">Câmera de vigilância</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_34" class="form-check-input" type="checkbox" name="fechadura_reforcada" <?php if(!empty($imov_fechadura_reforcada)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_34">Fechadura reforçada</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_35" class="form-check-input" type="checkbox" name="interfone" <?php if(!empty($imov_interfone)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_35">Interfone</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_36" class="form-check-input" type="checkbox" name="muro_com_cerca_eletrica" <?php if(!empty($imov_muro_com_cerca_eletrica)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_36">Muro com cerca elétrica</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_37" class="form-check-input" type="checkbox" name="portao_eletronico" <?php if(!empty($imov_portao_eletronico)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_37">Portão Eletrônico</label>
										</div>
										<div class="form-check form-check-inline">
											<input id="checkbox_38" class="form-check-input" type="checkbox" name="vigilancia_24_horas" <?php if(!empty($imov_vigilancia_24_horas)) { echo 'checked'; } ?>>
											<label class="form-check-label" for="checkbox_38">Vigilância 24 horas</label>
										</div>
									</div>
									<div class="mb-3">
										<div class="row"> 
											<div class="col-lg-12 mb-3">
												<label for="sincronizaEdicao">Deseja sincronizar esta edição com o sistema Gerenciador Imobiliário</label>
												<select class="form-control" id="sincronizaEdicao" name="sincronizaEdicao" required="">
													<option value="1">Sim</option>
													<option value="2">Não</option>
												</select>
											</div>
										</div>
									</div>

									<input type="hidden" name="gerenciadorImovelID" value="<?php echo $dadosImovel->gerencie_imovel_id; ?>">
								    <input type="hidden" name="atualizar_imovel" value="<?php echo $dadosImovel->id; ?>">
								    <button type="button" class="submit btn btn-primary w-100">ATUALIZAR IMÓVEL</button>
								</form>
							</div>
							<div class="tab-pane fade <?php if(isset($_GET['imgs'])) { echo 'show active'; } ?>" id="aba2">
								<form method="POST" id="frmgaleriaImagens" enctype="multipart/form-data" action="app/imovel/edita">
									<div class="row">
										<div class=" col-lg"   >	
											<div  id="galeriaContainer">	
												<div class="" id="galeriaImagensContainer">
													<div class="grid">
														<div class="item image-upload">
															<label for="uploadFileSelect">
																<div class="upload-icon">
																	<img class="icon" src="<?=BASE;?>/assets/images/others/upload-file.png">
																	<img class="prev" src="">
																</div>
															</label>
															<div class="remove hideElement"  ><i class="fa fa-times"></i></div>
															<input type="text" class="posicao" value="1" name="imagem[1][posicao]">
															<input id="uploadFileSelect" name="imagem[1][arquivo]" type="file" class=""  accept="image/png, image/gif, image/jpeg, image/webp"  multiple/>
														</div>
										 
													</div>

												</div>
											</div>
										</div>	
									</div> 
									<div class="row">
										<div class=" col-lg"   >
											<div class="alert alert-danger" id="imageUploadAlert"></div>
											<input type="hidden" class="imagensRemover" value="" name="imagensRemover">
											
											<input type="hidden" name="atualizar_imovel_imagens" value="<?php echo $dadosImovel->id; ?>">
											<button type="button" class="submit btn btn-primary w-100">ATUALIZAR IMAGENS DO IMÓVEL</button>
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>


				<?php include 'estrutura/copy.php';?>	
            </div>
         </div>
    </div>
	<?php include 'estrutura/rodape.php';?>
	<?php include 'estrutura/_modal_admin.php';?>
<?php
	if(!empty($imov_estado) AND !empty($imov_cidade)) {
?>
		<script type="text/javascript">
			$.getJSON('assets/estados_cidades.json', (data) => {
		        let items = [];
		        let options = '<option selected value disabled>Selecione o estado</option>';
		        for(val of data) {
		        	if(val.nome == '<?php echo $imov_estado; ?>') {
		        		options += '<option value="' + val.nome + '" selected>' + val.nome + '</option>';
		        	}
		        	else {
		            	options += '<option value="' + val.nome + '">' + val.nome + '</option>';
		            }
		        }
		        $('#estado').html(options);
		        $('#estado').change( () => {
		        	let options_cidades = '<option selected value disabled>Selecione a cidade</option>';
		            let str = $('#estado').val();
		            for(val of data) {
		                if(val.nome == str) {
		                    for(val_city of val.cidades) {
		                    	if(val_city == '<?php echo $imov_cidade; ?>') {
		                        	options_cidades += '<option value="' + val_city + '" selected>' + val_city + '</option>';
		                        }
		                        else {
		                        	options_cidades += '<option value="' + val_city + '">' + val_city + '</option>';
		                        }
		                    }
		                }
		            }
		            $('#cidade').html(options_cidades);
		        }).change();
		    });
		</script>
<?php

		// 
	}
?>

	
	
	<script src="https://cdn.jsdelivr.net/npm/muuri@0.9.5/dist/muuri.min.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/web-animations-js@2.3.2/web-animations.min.js"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/velocity/1.5.0/velocity.min.js"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/hammer.js/2.0.8/hammer.min.js"></script>
	<link rel="stylesheet" type="text/css" href="<?=BASE;?>assets/css/galeria-dragdrop.css?v=1.1.1"/>
	<style>
		#imageTabLoad, #imageUploadAlert{display: none}
	</style>
	
	
	<script type="text/javascript">

		
		
		
		var dragCounter = 0;
		var docElem = document.documentElement;
		
		var dragSortOptions = {

		};
		var grid = new Muuri('.grid', {
			dragEnabled: true,
			layoutOnResize: true,
			action: 'swap',
			threshold: 50,
			layoutDuration: 400,
			
			layoutEasing: 'ease',
			dragStartPredicate: {
				distance: 10,
				delay: 100,
			},
			dragReleaseDuration: 400,
			dragReleseEasing: 'ease',
			showEasing: 'cubic-bezier(0.215, 0.61, 0.355, 1)',
			dragStartPredicate: function (item, event) {
				if (grid.getItems().indexOf(item) === 0) {
					return false;
				}
				var isRemoveAction = elementMatches(event.target, '.remove, .remove i');
				return !isRemoveAction ? Muuri.ItemDrag.defaultStartPredicate(item, event) : false;
				//return Muuri.ItemDrag.defaultStartPredicate(item, event);
			},
			dragSortPredicate: function (item) {
				var result = Muuri.ItemDrag.defaultSortPredicate(item, dragSortOptions);
				return result && result.index === 0 ? false : result;
			} 
		})
		.on('dragStart', function (item, event) {
			++dragCounter;
			docElem.classList.add('dragging');
			
		})
		.on('dragEnd', function (item, event) {
			if (--dragCounter < 1) {
				docElem.classList.remove('dragging');
				
			}
			//console.log(grid.getItems().indexOf(item));
			updateIndices();
		})
			.on('synchronize', function () {
				//console.log('Synced!');
			})
			.on('remove', function() {
				//grid.sort('id', { layout: false });
				updateIndices();
				grid.refreshSortData();
			})
				.on('layoutStart', function (items, isInstant) {
					console.log(items, isInstant);
					updateIndices();
				})
				.on('move', updateIndices)
				  
				  
				  
	///carrega elementos
		<?php
			$omsselect = "SELECT * from imovel_galeria WHERE imovel_id = :imovel_id ORDER BY posicao asc";
			 
			try {
 				$omsresult = $conectDB->prepare($omsselect);
				$omsresult->bindParam(':imovel_id', $dadosImovel->id, PDO::PARAM_STR);
				$omsresult->execute();
				$omscontar = $omsresult->rowCount();
				if($omscontar > 0) {
					$contador = 2;
					while($omsmost = $omsresult->FETCH(PDO::FETCH_OBJ)){
						$imagemBD = 'assets/storage/'.$_SESSION['userCode'].'/imoveis/'.$dadosImovel->id.'/'.$omsmost->img;
						$imagem = (file_exists( $imagemBD )) ? ($imagem = BASE.$imagemBD) : ( BASE.'assets/storage/sem-foto.jpg' );
						 
		?>
						var itemElem = document.createElement('div');
						var items = '<div class="item image-upload" data-id="<?=$contador;?>">\
							<label for="imagem[<?=$contador;?>][arquivo]">\
								<div class="upload-icon" style="border: none">\
									<img class="prev" style="display: block" src="<?=$imagem;?>">\
								</div>\
							</label>\
							<div class="removeItem remove" imagemID="<?=$omsmost->id;?>"><i class="fa fa-times"></i></div>\
							<input type="text" class="" value="<?=$omsmost->id;?>" name="imagem[<?=$contador;?>][imagemID]">\
							<input type="text" class="posicao" value="<?=$contador;?>" name="imagem[<?=$contador;?>][posicao]">\
						</div> ';
						itemElem.innerHTML = items; 
						var newItemsLoad = grid.add(itemElem);
						grid.show(newItemsLoad);
		<?php	
						$contador ++;
					}
				}
			}
			catch(PDOException $e) {
				echo $e;
			}
		?>
		updateIndices();
	///carrega elementos
				  
		function readURL(input, grid) {
			const files = input.files;
			for (var i = 0; i < files.length; i++){
				const file = files[i];
				//alert(file);
				const reader = new FileReader();
				reader.onload = function(e) { 
					var totalImagens = $(".grid .item").length;
						var itemElem = document.createElement('div');
						totalImagens = totalImagens + 1;
							//var image = document.getElementById('output');
							//image.src = URL.createObjectURL(e.target.files[0]);
							var items = '<div class="item image-upload" data-id="' + totalImagens + '">\
								<label for="imagem['+totalImagens+'][arquivo]">\
									<div class="upload-icon" style="border: none">\
										<img class="prev" style="display: block" src="'+ e.target.result+'">\
									</div>\
								</label>\
								<div class="remove"><i class="fa fa-times"></i></div>\
								<input type="text" class="posicao" value="'+totalImagens+'" name="imagem['+totalImagens+'][posicao]">\
								<input readonly id="imagem['+totalImagens+'][arquivo]" name="imagem['+totalImagens+'][arquivo]" type="text" value="'+ e.target.result+'"/>\
							</div> ';
						console.log(e);	
						itemElem.innerHTML = items; 
						var newItems = grid.add(itemElem);
						grid.show(newItems);
				}
				reader.readAsDataURL(file);
			}
			updateIndices();
		}
		
		

		$("body").on("change", "input[name='imagem[1][arquivo]']", function() {
			$("#imageUploadAlert").fadeOut(100);
			$("#imageUploadAlert").html('');
			
			var selection = document.getElementById('uploadFileSelect');
			for (var i=0; i< selection.files.length; i++) {
				//var ext = selection.files[i].name.substr(-3);
				var re = /(?:\.([^.]+))?$/;
				var ext = re.exec( selection.files[i].name )[1];
				if(ext!== "jpg" && ext!== "jpeg" && ext!== "png" && ext!== "bmp" && ext!== "webp")  {
					$("#imageUploadAlert").fadeIn(100);
					$("#imageUploadAlert").html('Ops, você selecionou um arquivo não permitido, por favor, selecione apenas imagens para continuar: .jpg, .png, .jpeg, .bmp, .webp');
					return false;
				}
				/*
					//se maior que 10 MB -> bytes to mb
					if(selection.files[i].size > 10000000) {
						$("#imageUploadAlert").fadeIn(100);
						$("#imageUploadAlert").html('Ops, uma das imagens selecionadas possuí mais de 10 MB, selecione imagens com menos de 10 MB.');
						return false;
					}
				*/
			}
			
			readURL(this, grid);
		});
		
			 
				$("body").on("click", ".prev", function() {
					return false;
				});


			function updateIndices() {
				grid.getItems().forEach(function (item, i) {
					item.getElement().setAttribute('data-id', i + 1);
					item.getElement().querySelector('.posicao').value = i + 1 ;
					//console.log( item.getElement().querySelector('.posicao').value );
				});
			}
 
		function elementMatches(element, selector) {
			var p = Element.prototype;
			return (p.matches || p.matchesSelector || p.webkitMatchesSelector || p.mozMatchesSelector || p.msMatchesSelector || p.oMatchesSelector).call(element, selector);
		}


 

			$('.tabImagens').on('click', function (e) {
				setTimeout(function(){
					grid.refreshItems().layout();   	
				}, 600);
				
				//return false;

			})

			
			$("body").on("click", ".removeItem, .remove", function() {
				//remove imagem
				var imagemID 	= $(this).attr("imagemID");
				var gridItem 	= $(this).closest('div.muuri-item').attr('data-id');
				var gridItemEl 	= $(this).closest('div.muuri-item');

				var imagensRemocao = $('.imagensRemover').val();
				$('.imagensRemover').val(imagensRemocao+','+imagemID);
				
				var elem  = document.querySelectorAll('.item[data-id="'+gridItem+'"]'); 
				 
				console.log('item: '+elem);
				$(elem).fadeOut("normal", function() {
					$(this).closest('div.muuri-item').remove();
					grid.remove([elem], {removeElements: true});


					
						grid.refreshItems().layout();
						const currentItems = grid.getItems();
						grid.sort(currentItems);

				});
				//remove imagem
			});
	</script>
	
	
</body>
</html>