<?php
require 'app/bootstrap.php';
$conectDB = connectDB();
$conectDB->exec("set names utf8mb4");
include '__valida_login.php';
include 'app/libs/dns-checker/autoload.php';
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <title><?=$configSistema['sistema'];?> - Design do Site</title>
	<?php
		include 'estrutura/__css.php';
	?>
</head>
<body>
    <div class="app  ">
        <div class="layout ">
			<?php
				include 'estrutura/topo.php';
				include '_menu.php';
				
				$titulo = 'Acesso ao Site'; 
			?>
            <div class="page-container">
                <div class="main-content">
                   <div class="card  ">
                        <div class="card-body"> 
                            <h4 class=" "><?=$titulo;?></h4>
                            <div class="">
								<div class="m-t-15">
									<?php

					  					$userCode	  		= $_SESSION['userCode']; 

										if ($_SERVER['REQUEST_METHOD'] === 'POST')
										{
											//print_r($_POST);exit;
											$url    	 = stringInputCleaner($_POST['url']); 
											
											//checa se url já está configurada
											$bsucaURL = all($conectDB, ' site ', ' url ', " where url = '{$url}' and usuario_id <> '{$_SESSION['userID']}'");
											if( count($bsucaURL) >= 1 ){
												echo mensagem('erro', 'Este domínio já pertence a outro usuário', '', '');
											}
											else
											{
												$cadinsert = "
													UPDATE
														site
													SET
														url = :url
													WHERE
														usuario_id 	= :userID
												";
													$cadresult = $conectDB->prepare($cadinsert);
													$cadresult->bindParam(':url' , $url, PDO::PARAM_STR);
													$cadresult->bindParam(':userID' , $_SESSION['userID'], PDO::PARAM_STR);
													if($cadresult->execute()){
	 
														echo mensagem('sucesso', 'Registro atualizado com sucesso', '', '');
													}
													else
													{
														 echo mensagem('erro', 'Houve algo de errado ou suas alterações não foram realizadas', '', '');
													}
											}
										}

										$configuracoesSite = findItem($conectDB, 'site', ' * ', array("usuario_id"=>$_SESSION['userID']) );
									?>
									<form method="post" action="" id="" enctype="multipart/form-data">
										<div class="card"> 
											<div class="card-body">
											  
												<div class="row mb-xl-1 mb-9">
													<div class="col-lg-12">
 														<div class="form-group">
															<label for="namedash" class="d-block text-black-2 font-size-4 font-weight-semibold ">URL do seu site</label>
															<input type="url" class="form-control h-px-48" name="url" value="<?=@$configuracoesSite->url;?>" required required_m="URL Obrigatório">
															<?php
																if(!empty($configuracoesSite->url)){
																	$dominioSemHttp = explode("/", $configuracoesSite->url);
																	$dominioFinal = $dominioSemHttp[2];
																	
																	$provider = new \Mesour\DnsChecker\Providers\DnsRecordProvider();
																	$checker = new \Mesour\DnsChecker\DnsChecker($provider);
																	$dnsRecordSet = $checker->getDnsRecordSet( $dominioFinal, DNS_ALL );
																	echo '<pre>';print_r($dnsRecordSet);echo '</pre>';
																}
															?>
														</div>
													</div> 
												</div>
												 
												<div class="row">
													<div class="col-sm-3 text-left">
														<button type="submit" class="btn  btn-primary m-r-5">
															<i class="anticon anticon-loading m-r-5"></i>
															<i class="anticon anticon-check m-r-5"></i>
															<span>Salvar Alterações</span>
														</button>
													</div>
												</div>
											</div>
										</div>
									</form> 
								
								</div>
							</div>
						</div>
					</div>
                </div>
				
				<?php include 'estrutura/copy.php';?>	
            </div>
         </div>
    </div>
	<?php include 'estrutura/rodape.php';?>
	<?php include 'estrutura/_modal_admin.php';?>

	<link href="assets/vendors/izoColorPicker_1.0/izoColorPicker.css" rel="stylesheet">    
	<script src="assets/vendors/izoColorPicker_1.0/izoColorPicker.js"></script>

	<style type="text/css">
		 
	</style>
	
	<?php //include '_rodape.php';?>
  </div>

   
  <link rel="stylesheet" href="https://www.jqueryscript.net/demo/Bootstrap-4-Chosen-Plugin/dist/css/component-chosen.css" />
	 

  <?php include 'estrutura/__js.php';?>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/chosen/1.8.7/chosen.jquery.min.js" integrity="sha512-rMGGF4wg1R73ehtnxXBt5mbUfN9JUJwbk21KMlnLZDJh7BkPmeovBuddZCENJddHYYMkCh9hPFnPmS9sspki8g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
  <script type="text/javascript">
  	 
    $(".estados, .selectCidade").chosen( {
        width: "100%",
        placeholder_text_multiple: "Selecione",
        placeholder_text_single: "Selecione"
    });

	    $("#disciplinas, #curso_superior").chosen( {
	        width: "100%",
	        placeholder_text_multiple: "Selecione",
	        placeholder_text_single: "Selecione"
	    });


    $('.selectEstado').on('change', function(){
        var estado = $(this).val();
        $elementCitie = $(".selectCidade");

        $('.selectCidade option').prop('selected', false).trigger('chosen:updated');
        $elementCitie.html("");    
        $elementCitie.chosen().trigger('chosen:updated');

        $.getJSON('app/get/cities', {
                estadoID: estado,
                ajax: 'true'
            }, function(j){
            var options = '<option value=""></option>';
            for (var i = 0; i < j.length; i++) {

                $elementCitie.append('<option value="'+j[i].cityID+'">' + j[i].cityName + '</option>');
                 
            }
            
            $elementCitie.trigger("chosen:updated");
             
        });
    });

 
function readURL(input) {
    if (input.files && input.files[0]) {
        var reader = new FileReader();

        reader.onload = function (e) {
            $('#userActions').css('background', ' url('+e.target.result+')');
            $(".imageUpTextDemo").fadeIn(200);
        }

        reader.readAsDataURL(input.files[0]);
    }
}

	$("#fileUpload").change(function(){
	    readURL(this);
	});

  	
    $(function(){
        $('.colorPicker').izoColorPicker({
            buttonApplyTitle:'Selecionar',
            buttonCancelTitle:'Cancelar',
            myColors: '',
            onApply: (color)=>{ 
                console.log('Selected color: '+color) 
            },
            onSave: (color,colors)=>{ 
                console.log('Saved color: '+color)
                console.log('Saved color list: '+ colors.join())
            },
            onRemove: (color,colors)=>{ 
                console.log('Removed color: '+color)
                console.log('Saved color list: '+ colors.join())
            }
        })                	
    })
  </script>

</body>
</html>