<?php
	include 'app.php';
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
	<base href="<?=$site['SistemaBaseHref'];?>">
	<title><?=$site['nome'];?></title>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
	<link rel="stylesheet" href="assets/css/style.css?v=<?=$arquivosVersao['css'];?>">
	<link rel="stylesheet" href="color.php?colorBase=<?=str_replace("#", "", $site['cor_base']);?>" id="colors">
	<style type="text/css">
		label { 
		    margin-bottom: 0;
		}
			.parallax #titlebar {
			    padding: 120px 0 40px;
			}
	</style>
</head>
<body>
<div id="wrapper">
	<?php
		$homeClasseTextWhite = 'white';
		include '__header.php';
	?>
	<div class="clearfix"></div> 
	
	
	<div class="parallax titlebar"
		data-background="assets/images/popular-location-03.jpg"
		data-color="#000"
		data-color-opacity="0.7"
		data-img-width="800"
		data-img-height="505">

		<div id="titlebar">
			<div class="container">
				<div class="row">
					<div class="col-md-12">
						<h2>Imóveis</h2>
					</div>
				</div>
			</div>
		</div>
	</div>


	
	
 

<div class="container">
	<div class="row">
		<div class="col-lg-8 col-md-8">
				<div class="row margin-bottom-15">
					<div class="col-md-6">
						 
					</div>
					<div class="col-md-6">
						<div class="layout-switcher">
							<a href="#" class="list"><i class="fa fa-th-list"></i></a>
							<a href="#" class="grid"><i class="fa fa-th-large"></i></a>
						</div>
					</div>
				</div>

				
				<!-- Listings -->
				<div class="listings-container list-layout">
						<?php
							$sqlBusca = '';
							$sqlCidade = '';
							$sqlCategoria = '';
							$sqlAreaMin = '';
							$sqlPrecoMax = ''; 
							$sqlQuartos = ''; 
							$sqlBanheiros = ''; 


							if ($_SERVER['REQUEST_METHOD'] === 'GET') {
								if(isset($_GET['busca'])){

									//campo busca (todos, comprar, vender)
									if( (isset($_GET['busca'])) && (!empty($_GET['busca']))  && ($_GET['busca'] !== 'todos') ){
										$sqlBusca = ' and situacao = '.(int)$_GET['busca'];
									}

									//campo cidade
									if( (isset($_GET['cidade'])) && (!empty($_GET['cidade'])) ){
										$sqlCidade = ' and cidade = '.stringInputCleaner( $_GET['cidade'] );
									}

									//campo categoria
									if( (isset($_GET['categoria'])) && (!empty($_GET['categoria'])) ){
										$sqlCategoria = ' and categoria = '.stringInputCleaner( $_GET['categoria'] );
									}

									//campo area minima
									if( (isset($_GET['areaMin'])) && (!empty($_GET['areaMin'])) ){
										$sqlAreaMin = ' and area_total >= '.stringInputCleaner( $_GET['areaMin'] );
									}

									//campo preco maximo
									if( (isset($_GET['precoMax'])) && (!empty($_GET['precoMax'])) ){
										$sqlPrecoMax = ' and valor <= '.stringInputCleaner( $_GET['precoMax'] );
									}

										//campo quartos (dormitorios)
										if( (isset($_GET['quartos'])) && (!empty($_GET['quartos'])) ){
											$sqlQuartos = ' and dormitorio >= '.stringInputCleaner( $_GET['quartos'] );
										}

										//campo banheiros
										if( (isset($_GET['banheiros'])) && (!empty($_GET['banheiros'])) ){
											$sqlBanheiros = ' and banheiro >= '.stringInputCleaner( $_GET['banheiros'] );
										}

								}
							}

	$sqlBusca = "
		select
			imovel.id AS imovelID,
			imovel.codigo,
			dormitorio,
			titulo,
			valor,
			area_total,
			banheiro,
			sala,
			situacao,
			bairro,
			if(situacao=1, 'Aluguel', 'Vender') as situacao,
			categoria.id,
			categoria.nome
		from
			imovel,
			categoria
		WHERE
			imovel.usuario_id = '{$site['usuarioID']}' and
			categoria.id = imovel.categoria
			
			$sqlBusca
			$sqlCidade
			$sqlCategoria
			$sqlAreaMin
			$sqlPrecoMax

			$sqlQuartos
			$sqlBanheiros

		order by
			imovel.id desc
	";
							//echo '<pre>';print_r($sqlBusca);echo '</pre>';
							$searchItem  = query($conectDB, '', $sqlBusca ); 

 
							if( count($searchItem) > 0 ){
								foreach($searchItem as $data)
								{ 
										$imagens = '';
										$imagens = array();
										$searchImages  = query($conectDB, '', "
											select
												img
											from
												imovel_galeria
											WHERE
												imovel_id = '{$data->imovelID}'
											
											order by posicao asc
											limit 3
										"); 
			 
										if( count($searchImages) >= 1 ){
											foreach($searchImages as $images)
											{
												$imagens[] = $site['imoveisImagens'].'/'.$data->imovelID.'/'.$images->img;
											}
										}
										else
										{
											$imagens[] = $site['imagens']."/storage/sem-foto.jpg";
										}
										
									include '_imovel_lista_item_list.php';
								}
							}
							else
							{
								echo '

 									<div class="col-md-12 text-center">
										<script src="https://unpkg.com/@lottiefiles/lottie-player@latest/dist/lottie-player.js"></script>
										<lottie-player src="https://assets6.lottiefiles.com/packages/lf20_i2rkmcsu.json"  background="transparent"  speed="1"  style="width: 100%; height: 300px;"  loop  autoplay></lottie-player>
										<h2>Não localizamos nenhum imóvel nesta busca, refine sua busca</h2> 
									</div>
 								';
							}
						?>
	
				</div>
		</div>
		
		

		<!-- Sidebar
		================================================== -->
		<div class="col-md-4">
			<div class="sidebar sticky right">
				
				<div class="widget margin-bottom-40">
					<form   method="GET" action="imoveis">
						<h3 class="margin-top-0 margin-bottom-15">Faça uma busca</h3>
						<!-- Row -->
						<div class="row with-forms">
							<div class="col-md-12">
								<label>Para</label>
								<select data-placeholder=""  name="busca" class="chosen-select-no-single" >
									<option value="todos">Todos</option>	
									<option value="1" <?=( (isset($_GET['busca'])) && ((int)$_GET['busca'] == 1) ) ? ("selected") : ("");?>>Alugar</option>
									<option value="2" <?=( (isset($_GET['busca'])) && ((int)$_GET['busca'] == 2) ) ? ("selected") : ("");?>>Vender</option>
								</select>
							</div>
						</div>


						<!-- Row -->
						<div class="row with-forms">
							<div class="col-md-12">
								<label>Tipo de Imóvel</label>
								<select data-placeholder=""  name="tipo" class="chosen-select-no-single" >
									<option value="">Tipo</option>	
									<?php
										$searchItem  = query($conectDB, '', "
											select
												categoria.id,
												categoria.nome
											from
												imovel,
												categoria
											WHERE
												imovel.usuario_id = '{$site['usuarioID']}' and
												categoria.id = imovel.categoria
											group by
												categoria.id
											order by
												categoria.nome asc
										"); 
										if( count($searchItem) > 0 ){
											foreach($searchItem as $value)
											{ 
												$seleciona = '';
												if( (isset($_GET['tipo'])) && ((int)$_GET['tipo'] == $value->id) ){
													$seleciona = 'selected';
												}
												echo '<option '.$seleciona.' value="'.$value->id.'">'.$value->nome.'</option>	';
											}
										}
									?>
								</select>
							</div>
						</div>
						<!-- Row / End -->

	  

						<!-- Row -->
						<div class="row with-forms">
							<div class="col-md-6">
								<label>Quartos</label>
								<select data-placeholder="Quartos"  name="quartos" class="chosen-select-no-single" >
									<option value=""></option>	
									<?php
										$valor_minimo  = 1;
										$valor_maximo = 5;
										while($valor_minimo <= $valor_maximo )
										{
											$seleciona = '';
											if( (isset($_GET['quartos'])) && ((int)$_GET['quartos'] == $valor_minimo) ){
											 	$seleciona = 'selected';
											}
											echo '<option '.$seleciona.' value="'.$valor_minimo.'">'.$valor_minimo.'</option>';
											$valor_minimo++;
										}
									?>
								</select>
							</div>
								<div class="col-md-6">
									<label>Banheiros</label>	
									<select data-placeholder="Banheiros"  name="banheiros" class="chosen-select-no-single" >
										<option value=""></option>	
										<?php
											$valor_minimo  = 1;
											$valor_maximo = 5;
											while($valor_minimo <= $valor_maximo )
											{
												$seleciona = '';
												if( (isset($_GET['banheiros'])) && ((int)$_GET['banheiros'] == $valor_minimo) ){
												 	$seleciona = 'selected';
												}
												echo '<option '.$seleciona.' value="'.$valor_minimo.'">'.$valor_minimo.'</option>';
												$valor_minimo++;
											}
										?>
									</select>
								</div>
						</div>
						<!-- Row / End -->

						<!-- Row -->
						<div class="row with-forms">
							<div class="col-md-6">
								<label>Preço de</label>
								<input type="text" name="precoMin" class="moeda form-control">
							</div>
								<div class="col-md-6">
									<label>Até</label>	
									<input type="text" name="precoMin" class="moeda form-control">
								</div>
						</div> 

						<!-- More Search Options -->
						<a href="#" class="more-search-options-trigger margin-bottom-10 margin-top-10" data-open-title="Adicionais" data-close-title="Adicionais"></a>

						<div class="more-search-options relative">
							Áreas comuns
							<div class="checkboxes one-in-row margin-bottom-10">
								<?php
									$areaComum['itens'] = array(
										array('Elevador', 'elevador'),
										array('Edícula', 'edicula'),
										array('Horta', 'horta'),
										array('Jardim", Espaço Interno', 'jardim'),
										array('Área de Serviço', 'area_de_servico'),
										array('Bar', 'bar'),
										array('Biblioteca', 'biblioteca'),
										array('Closet', 'closet'),
										array('Copa', 'copa'),
										array('Despensa', 'despensa'),
										array('Escritório', 'escritorio'),
										array('Lareira', 'lareira'),
										array('Sala de Ginástica', 'sala_de_ginastica'),
										array('Sala de Jantar", Condomínio', 'sala_de_jantar'),
										array('Acesso à Deficientes', 'acesso_a_deficiente'),
										array('Gerador de Energia', 'gerador_de_energia'),
										array('Guarita', 'guarita'),
										array('Lavanderia Coletiva', 'lavanderia_coletiva'),
										array('Medição', 'medicao'),
										array('Água Individual', 'agua_individual'),
										array('Portaria 24 Horas", Lazer/Entretenimento', 'portaria_24_horas'),
										array('Bicicletário', 'bicicletario'),
										array('Churrasqueira', 'churrasqueira'),
										array('Ducha externa', 'ducha_externa'),
										array('Piscina', 'piscina'),
										array('Playground', 'playground'),
										array('Quadra de Esportes', 'quadra_de_esportes'),
										array('Quadra Tênis', 'quadra_tenis'),
										array('Sala Ginástica/Fitness', 'sala_ginastica_fitness'),
										array('Salão de Festas', 'salao_de_festas'),
										array('Salão de Jogos', 'salao_de_jogos'),
										array('Sauna', 'sauna'),
										array('Segurança', 'seguranca'),
										array('Alarme', 'alarme'),
										array('Câmera de vigilância', 'camera_de_vigilancia'),
										array('Fechadura reforçada', 'fechadura_reforcada'),
										array('Interfone', 'interfone'),
										array('Muro com cerca elétrica', 'muro_com_cerca_eletrica'),
										array('Portão Eletrônico', 'portao_eletronico'),
										array('Vigilância 24 horas', 'vigilancia_24_horas'),
									);

									//$areaComum = array("Edícula", "Horta", "Jardim", "Espaço Interno", "Área de Serviço", "Bar", "Biblioteca", "Closet", "Copa", "Despensa", "Escritório", "Lareira", "Sala de Ginástica", "Sala de Jantar", "Condomínio", "Acesso à Deficientes", "Gerador de Energia", "Guarita", "Lavanderia Coletiva", "Medição", "Água Individual", "Portaria 24 Horas", "Lazer/Entretenimento", "Bicicletário", "Churrasqueira", "Ducha externa", "Piscina", "Playground", "Quadra de Esportes", "Quadra Tênis", "Sala Ginástica/Fitness", "Salão de Festas", "Salão de Jogos", "Sauna", "Segurança", "Alarme", "Câmera de vigilância", "Fechadura reforçada", "Interfone", "Muro com cerca elétrica", "Portão Eletrônico", "Vigilância 24 horas");
									//echo '<pre>';print_r($areaComum['itens']);echo '</pre>';

									$conta = 1;
									foreach ($areaComum['itens'] as $key => $value) {
										//echo $areaComum['itens'][$key][1].'<br>';
										echo
										'
											<input id="check-'.$areaComum['itens'][$key][1].'" type="checkbox" name="areaComum[]" value="'.$areaComum['itens'][$key][1].'">
											<label for="check-'.$areaComum['itens'][$key][1].'">'.$areaComum['itens'][$key][0].'</label>
										';
	 									$conta ++;
									}
								?>


						
							</div>
						</div>

						<button type="submit" class="button  fullwidth margin-top-30">Buscar</button>
					</form>	
				</div>

			</div>
		</div>		
	</div>
</div>



	<?php include '__footer.php';?>
	<script type="text/javascript" src="assets/scripts/jquery-2.2.0.min.js"></script>
	<script type="text/javascript" src="assets/scripts/chosen.min.js"></script>
	<script type="text/javascript" src="assets/scripts/magnific-popup.min.js"></script>
	<script type="text/javascript" src="assets/scripts/owl.carousel.min.js"></script>
	<script type="text/javascript" src="assets/scripts/rangeSlider.js"></script>
	<script type="text/javascript" src="assets/scripts/sticky-kit.min.js"></script>
	<script type="text/javascript" src="assets/scripts/slick.min.js"></script>
	<script type="text/javascript" src="assets/scripts/masonry.min.js"></script>
	<script type="text/javascript" src="assets/scripts/mmenu.min.js"></script>
	<script type="text/javascript" src="assets/scripts/tooltips.min.js"></script>
	<script type="text/javascript" src="assets/scripts/custom.js"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js" integrity="sha512-pHVGpX7F/27yZ0ISY+VVjyULApbDlD0/X0rgGbTqCE7WFW5MezNTWG/dnhtbBuICzsd0WQPgpE4REBLv+UqChw==" crossorigin="anonymous"></script>
	<script type="text/javascript" src="assets/scripts/app.js"></script>

	<script src="https://kit.fontawesome.com/77e3b86f29.js" crossorigin="anonymous"></script>
</div>
</body>
</html>